/**
 * \file bmc_dev_sel.h
 *
 * Description: BMC System Event Log Device
 *
 * (c) 2004 Peppercon AG, Ralf Guenther <rgue@peppercon.de>
 */

#ifndef __BMC_DEV_SEL_H__
#define __BMC_DEV_SEL_H__

#include "pp/bmc/utils.h"

/**
 * Set/Get the time for SEL and SDRR
 *
 * ICTS assumes that get/set time of SEL and SDRR uses the same
 * storage, so they tried to set the time via SDRR and read it back
 * via SEL getting a different value.
 */
int pp_sel_cmd_get_sel_sdrr_time(imsg_t *imsg);
int pp_sel_cmd_set_sel_sdrr_time(imsg_t *imsg);

/**
 * Initializes the BMC SEL device and registers it at the BMC core.
 * @return PP_SUC if success
 *         PP_ERR if error
 */
int pp_bmc_dev_sel_init(void);

/**
 * Finishes the BMC SEL device and unregisters it at the BMC core.
 */
void pp_bmc_dev_sel_cleanup(void);

/**
 * Enable/Disable SEL logging. If set to 0, the processing of events
 * from PCI mgmt bus and IPMB is disabled. Events from those channels
 * will not be processed in PEF nor put in the message queue or the SEL.
 * 
 * The SEL/event receiver starts enabled.
 */
void bmc_dev_sel_set_enable(unsigned char value);

/**
 * Get SEL logging status. The SEL/event receiver starts enabled.
 * returns 1 if SEL logging is enabled unconditionally
 * returns 0 if SEL logging from IPMB is disabled
 */
unsigned char bmc_dev_sel_get_enable(void);

#endif /* !__BMC_DEV_SEL_H__ */
