/**
 * bmc_msg_tracker.h
 *
 * Tracks ipmi messages in order to match their responses
 * 
 * (c) 2004 Peppercon AG, 12/02/2004, tbr@peppecon.de
 */

#ifndef __PP_BMC_MSG_TRACKER_H__
#define __PP_BMC_MSG_TRACKER_H__

#include <pp/bmc/bmc_imsg.h>

/**
 * initialices the msg tracker
 */
int pp_bmc_mtrack_init(void);

/**
 * msg tracker cleanup, discards and free's all data and
 * stops all associated timeout timers
 */
void pp_bmc_mtrack_cleanup(void);

/**
 * callback type in case a msg could be tracked
 */
typedef int (*pp_bmc_mtrack_cb_t)(imsg_t* imsg, void* ctx);

/**
 * callback type in case tracking of a msg timed out
 */
typedef int (*pp_bmc_mtrack_to_cb_t)(void* ctx);

/**
 * sends a ipmi msg by way of the msg tracker, i.e.
 * the tracker will be able to match responses to msg
 * it sent. In this case a callback will be executed with
 * the context given in send
 * @param imgs the msg to send
 * @param ctx arbitray data
 * @return PP_SUC, PP_ERR
 */
int pp_bmc_mtrack_send_msg(imsg_t* imsg, pp_bmc_mtrack_cb_t cb,
			   pp_bmc_mtrack_to_cb_t to_cb, void* ctx);

/**
 * checks a mesg wether it cmd/repsonse counterpart has
 * been tracked by the tracker.
 * If yes, the according callback will be fired.
 * @param imsg the msg to check
 * @return PP_SUC msg was tracked and handled
 *         PP_ERR msg was not handled
 */
int pp_bmc_mtrack_handle(imsg_t* imsg);



#endif
