/**
 * bmc_nv_storage_file.c
 *
 * Implements a non-volatile storage based on a filesystem (flash on lara)
 *
 * (c) 2004 Peppercon AG, Georg Hoesch <geo@peppercon.de>
 */

#include <fcntl.h>
#include <unistd.h>
#include <string.h>
#include <stdlib.h>
#include <fcntl.h>

#include <pp/base.h>
#include <pp/bmc/debug.h>
#include <pp/bmc/utils.h>
#include <pp/bmc/bmc_config.h>
#include <pp/bmc/bmc_nv_storage.h>


int bmc_nv_open(int* fd, const char* filename) {
    char* file_name_full = malloc(strlen(PP_BMC_FLASH_ROOT)
				  + sizeof(filename) + 1);
    strcat(strcpy(file_name_full, PP_BMC_FLASH_ROOT), "/");
    strcat(file_name_full, filename);
    
    *fd = open(file_name_full, O_RDWR | O_CREAT, S_RW_RW_RW_);
    if (*fd < 0) {
        pp_bmc_log_perror("[bmc_nv_storage_file] could not open file %s", file_name_full);
        free(file_name_full);
        return PP_ERR; /* file not createable */
    }
    
    free(file_name_full);
    return PP_SUC;
}

int bmc_nv_read(int fd, void *buf, int count) {
    int rv;
    //pp_bmc_log_debug("bmc_nv_read %d, %u, %d", fd, buf, count);
    rv = read(fd, buf, count);
    if (rv < 0) {
        pp_bmc_log_perror("[bmc_nv_storage_file] could not read from file %d: %d", fd, rv);
        return PP_ERR;
    }
    return rv;
}

int bmc_nv_write(int fd, const void *buf, int count) {
    int rv;
    rv = write(fd, buf, count);
    if (rv<0) {
        pp_bmc_log_perror("[bmc_nv_storage_file] could not write to file %d: %d", fd, rv);
        return PP_ERR;
    }
    return rv;
}

int bmc_nv_lseek(int fd, int offset, int origin) {
    return lseek(fd, offset, origin);
}

void bmc_nv_close(int fd) {
    close(fd);
}
