/**
 * bmc_seq_number.c
 *
 * bmc and channel unique sequence numbers generater
 * 
 * (c) 2004 Peppercon AG, 12/03/2004, tbr@peppecon.de
 */

#include <assert.h>
#include <pp/bmc/ipmi_chan.h>
#include "bmc_seq_number.h"

/*
 * sequence numbers a 6 bit integers so a 64bit longlong type
 * will be sufficient to remember whether a particular sequence
 * number has been assigned.
 */
typedef struct seqnos_s {
    long long seqnos;
    int next_seqno;
} seqnos_t;

static seqnos_t seqno_channels[IPMI_CHAN_MAX + 1] = {
    {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, 
    {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}
};

#define SEQ_MAX 64
#define SEQ_INC(s) (((s) + 1) % SEQ_MAX)

char pp_bmc_seqno_assign(unsigned char channel) {
    seqnos_t* se = &seqno_channels[channel];
    int i, s;
    long long m;

    for (i = 0, s = se->next_seqno; i < SEQ_MAX; ++i, s = SEQ_INC(s)) {
	m = 1 << s;
	if ((se->seqnos & m) == 0) {
	    se->seqnos = se->seqnos | m;
	    se->next_seqno = SEQ_INC(s);
	    return s;
	}
    }
    // nothing free
    return -1;
}


void pp_bmc_seqno_release(char channel, unsigned char seqno) {
    seqnos_t* se = &seqno_channels[(int)channel];
    long long m = (long long)1 << seqno;
    
    assert((se->seqnos & m));
    
    se->seqnos = se->seqnos & ~m;
}
