/**
 * \file bmc.h
 *
 * Description: Global functions of BMC (IPMI server)
 *
 * (c) 2005 Peppercon AG, Ralf Guenther <rgue@peppercon.de>
 */

#ifndef __BMC_H__
#define __BMC_H__

/**
 * init the BMC and its devices
 * @return PP_ERR (-1) in case of error, else PP_SUC (0)
 */
int pp_bmc_init(void);

/**
 * cleanup BMC and devices
 */
void pp_bmc_cleanup(void);

/**
 * start BMC's main thread
 * @return PP_ERR (-1) in case of error, else PP_SUC (0)
 */
int pp_bmc_start(void);

/**
 * stop BMC's main thread and wait for completion
 * @return PP_ERR (-1) in case of error, else PP_SUC (0)
 */
int pp_bmc_stop(void);

#if defined(PP_FEAT_IPMI_SERVER_FKT_INJECT)
/**
 * run funktion pointed to by fkt with param ctx in BMC execution
 * context
 * @return PP_ERR in case of error, else PP_SUC
 */
int pp_bmc_run_fkt(int(*fkt)(void*), void* ctx);
#endif /* PP_FEAT_IPMI_SERVER_FKT_INJECT */
    
#endif /* !__BMC_H__ */
