/*****************************************************************************\
* bmc_dev_oem_pp_rpc_isens_nr.h                                               *
*                                                                             *
* generic definition of isens numbers for RPC unit, board and receptacle      *
* sensors according to PSD                                                    *
*                                                                             *
* (c) 2006 Peppercon AG, tweb@raritan.com                                     *
\*****************************************************************************/

#ifndef __BMC_DEV_OEM_PP_RPC_ISENS_NR_H__
#define __BMC_DEV_OEM_PP_RPC_ISENS_NR_H__

/*** generic *****************************************************************/

#define RPC_MAX_SENSOR 0xF7

/*** IPMI sensor definitions *************************************************/

#define RPC_SENSOR(__outlet__, __sensor__) \
            ((((__outlet__) & 0x1f) << 3) | ((__sensor__) & 0x07))

#define RPC_RECEPTACLE(__sensor_nr__) ((__sensor_nr__) >> 3)

/*** receptacle sensors ******************************************************/
            
#define RPC_RECEPTACLE_SENSORNR_RMS_CURRENT             0
#define RPC_RECEPTACLE_SENSORNR_RMS_PHASE               1
#define RPC_RECEPTACLE_SENSORNR_MAX_RMS_CURRENT         2
#define RPC_RECEPTACLE_SENSORNR_TRUE_RMS_CURRENT        3
#define RPC_RECEPTACLE_SENSORNR_APPARENT_RMS_POWER      4
#define RPC_RECEPTACLE_SENSORNR_MAX_TRUE_RMS_POWER      5
#define RPC_RECEPTACLE_SENSORNR_AVERAGE_REAL_RMS_POWER  6

#define RPC_RECEPTACLE_SENSOR(__receptacle__, __sensor__) \
            RPC_SENSOR((__receptacle__), (__sensor__))
            
#define RPC_RECEPTACLE_SENSOR_RMS_CURRENT(__receptacle__) \
            RPC_RECEPTACLE_SENSOR((__receptacle__), RPC_RECEPTACLE_SENSORNR_RMS_CURRENT)
#define RPC_RECEPTACLE_SENSOR_RMS_PHASE(__receptacle__) \
            RPC_RECEPTACLE_SENSOR((__receptacle__), RPC_RECEPTACLE_SENSORNR_RMS_PHASE)
#define RPC_RECEPTACLE_SENSOR_MAX_RMS_CURRENT(__receptacle__) \
            RPC_RECEPTACLE_SENSOR((__receptacle__), RPC_RECEPTACLE_SENSORNR_MAX_RMS_CURRENT)
#define RPC_RECEPTACLE_SENSOR_TRUE_RMS_CURRENT(__receptacle__) \
            RPC_RECEPTACLE_SENSOR((__receptacle__), RPC_RECEPTACLE_SENSORNR_TRUE_RMS_CURRENT)
#define RPC_RECEPTACLE_SENSOR_APPARENT_RMS_POWER(__receptacle__) \
            RPC_RECEPTACLE_SENSOR((__receptacle__), RPC_RECEPTACLE_SENSORNR_APPARENT_RMS_POWER)
#define RPC_RECEPTACLE_SENSOR_MAX_TRUE_RMS_POWER(__receptacle__) \
            RPC_RECEPTACLE_SENSOR((__receptacle__), RPC_RECEPTACLE_SENSORNR_MAX_TRUE_RMS_POWER)
#define RPC_RECEPTACLE_SENSOR_AVERAGE_REAL_RMS_POWER(__receptacle__) \
            RPC_RECEPTACLE_SENSOR((__receptacle__), RPC_RECEPTACLE_SENSORNR_AVERAGE_REAL_RMS_POWER)
            
#define IS_RPC_RECEPTACLE_SENSOR(__sensor_num__) \
            (((__sensor_num__) >> 3) < RPC_POWER_BRANCH_SENSORNR ? 1 : 0)
            
#define IS_RPC_RECEPTACLE_SENSOR_RMS_CURRENT(__sensor_num__) \
            (IS_RPC_RECEPTACLE_SENSOR((__sensor_num__)) && \
             ((__sensor_num__) & 0x07) == \
             RPC_RECEPTACLE_SENSORNR_RMS_CURRENT ? 1 : 0)
#define IS_RPC_RECEPTACLE_SENSOR_RMS_PHASE(__sensor_num__) \
            (IS_RPC_RECEPTACLE_SENSOR((__sensor_num__)) && \
             ((__sensor_num__) & 0x07) == \
             RPC_RECEPTACLE_SENSORNR_RMS_PHASE ? 1 : 0)
#define IS_RPC_RECEPTACLE_SENSOR_MAX_RMS_CURRENT(__sensor_num__) \
            (IS_RPC_RECEPTACLE_SENSOR((__sensor_num__)) && \
             ((__sensor_num__) & 0x07) == \
             RPC_RECEPTACLE_SENSORNR_MAX_RMS_CURRENT ? 1 : 0)
#define IS_RPC_RECEPTACLE_SENSOR_TRUE_RMS_CURRENT(__sensor_num__) \
            (IS_RPC_RECEPTACLE_SENSOR((__sensor_num__)) && \
             ((__sensor_num__) & 0x07) == \
             RPC_RECEPTACLE_SENSORNR_TRUE_RMS_CURRENT ? 1 : 0)
#define IS_RPC_RECEPTACLE_SENSOR_APPARENT_RMS_POWER(__sensor_num__) \
            (IS_RPC_RECEPTACLE_SENSOR((__sensor_num__)) && \
             ((__sensor_num__) & 0x07) == \
             RPC_RECEPTACLE_SENSORNR_APPARENT_RMS_POWER ? 1 : 0)
#define IS_RPC_RECEPTACLE_SENSOR_MAX_TRUE_RMS_POWER(__sensor_num__) \
            (IS_RPC_RECEPTACLE_SENSOR((__sensor_num__)) && \
             ((__sensor_num__) & 0x07) == \
             RPC_RECEPTACLE_SENSORNR_MAX_TRUE_RMS_POWER ? 1 : 0)
#define IS_RPC_RECEPTACLE_SENSOR_AVERAGE_REAL_RMS_POWER(__sensor_num__) \
            (IS_RPC_RECEPTACLE_SENSOR((__sensor_num__)) && \
             ((__sensor_num__) & 0x07) == \
             RPC_RECEPTACLE_SENSORNR_AVERAGE_REAL_RMS_POWER ? 1 : 0)
            

/*** power branch sensors ****************************************************/

#define RPC_POWER_BRANCH_SENSORNR                       24

#define RPC_POWER_BRANCH_SENSORNR_RMS_VOLTAGE           0
#define RPC_POWER_BRANCH_SENSORNR_RMS_CURRENT           1

#define RPC_POWER_BRANCH_SENSOR(__branch__, __sensor__) \
            RPC_SENSOR((__branch__) + RPC_POWER_BRANCH_SENSORNR, (__sensor__))
#define RPC_POWER_BRANCH_SENSOR_RMS_VOLTAGE(__branch__) \
            RPC_POWER_BRANCH_SENSOR((__branch__), RPC_POWER_BRANCH_SENSORNR_RMS_VOLTAGE)
#define RPC_POWER_BRANCH_SENSOR_RMS_CURRENT(__branch__) \
            RPC_POWER_BRANCH_SENSOR((__branch__), RPC_POWER_BRANCH_SENSORNR_RMS_CURRENT)

/*** unit sensors ************************************************************/
            
#define RPC_UNIT_SENSORNR                               30
// change PSD! this crashes with IPMI predefined sensors as e.g. PEF 
//#define RPC_UNIT_SENSORNR                               31

#define RPC_UNIT_SENSORNR_CIRCUIT_BREAK_0               0
#define RPC_UNIT_SENSORNR_CIRCUIT_BREAK_1               1
#define RPC_UNIT_SENSORNR_RMS_CURRENT                   2
#define RPC_UNIT_SENSORNR_MAX_RMS_CURRENT               3
#define RPC_UNIT_SENSORNR_TEMP                          4
#define RPC_UNIT_SENSORNR_TRUE_POWER                    5
#define RPC_UNIT_SENSORNR_APPARENT_POWER                6

#define RPC_UNIT_SENSOR_CIRCUIT_BREAK_0 \
            RPC_SENSOR(RPC_UNIT_SENSORNR, RPC_UNIT_SENSORNR_CB_0)
#define RPC_UNIT_SENSOR_CIRCUIT_BREAK_1 \
            RPC_SENSOR(RPC_UNIT_SENSORNR, RPC_UNIT_SENSORNR_CB_1)
#define RPC_UNIT_SENSOR_RMS_CURRENT \
            RPC_SENSOR(RPC_UNIT_SENSORNR, RPC_UNIT_SENSORNR_RMS_CURRENT)
#define RPC_UNIT_SENSOR_MAX_RMS_CURRENT \
            RPC_SENSOR(RPC_UNIT_SENSORNR, RPC_UNIT_SENSORNR_MAX_RMS_CURRENT)
#define RPC_UNIT_SENSOR_TEMP \
            RPC_SENSOR(RPC_UNIT_SENSORNR, RPC_UNIT_SENSORNR_TEMP)
#define RPC_UNIT_SENSOR_TRUE_POWER \
            RPC_SENSOR(RPC_UNIT_SENSORNR, RPC_UNIT_SENSORNR_TRUE_POWER)
#define RPC_UNIT_SENSOR_APPARENT_POWER \
            RPC_SENSOR(RPC_UNIT_SENSORNR, RPC_UNIT_SENSORNR_APPARENT_POWER)

#endif /* __BMC_DEV_OEM_PP_RPC_ISENS_NR_H__ */
