/**
 * bmc_nv_storage.h
 *
 * Abstraction for non volatile storage.
 * The commands defined here comply (more or less) with the 
 *
 * (c) 2004 Peppercon AG, Georg Hoesch <geo@peppercon.de>
 */

/**
 * Opens a file for reading (rw, no flags)
 * @param fd pointer to filedescriptor (set to -1 on error)
 * @param filename name of the file to open, excluding directories
 * @returns PP_SUC on success
 * @returns PP_ERR if problems have been encountered
 */ 
int bmc_nv_open(int* fd, const char* filename);

/**
 * Reads up to count bytes from tje file into the provided buffer.
 * @returns the number of bytes that have been read, PP_ERR if problems have been encountered
 */
int bmc_nv_read(int fd, void *buf, int count);

/**
 * Writes count bytes from the provided buffer to the file.
 * @returns the number of bytes that have been written, PP_ERR if problems have been encountered
 */
int bmc_nv_write(int fd, const void *buf, int count);

/**
 * And an offset for further read- and write operations within the file.
 * @param origin sets the origin of the repositioning as defined in lseek (SEEK_SET, SEEK_CUR, SEEK_END)
 * @returns the new absolute offset
 */
int bmc_nv_lseek(int fd, int offset, int origin);

/**
 * Close the specified file
 */
void bmc_nv_close(int fd);




