/**
 * bmc_sel_record.h
 *
 * The system event log record definition. Header file only,
 * implemented by bmc_dev_sel_nv.c.
 * 
 * (c) 2005 Peppercon AG, Georg Hoesch <geo@peppercon.de>
 */
 
#ifndef __BMC_SEL_RECORD_H__
#define __BMC_SEL_RECORD_H__

#include "pp/bmc/utils.h"

// PACKED doesn't work in typedefs
struct sel_entry_s {
    unsigned short id_le16;   /* the ID is stored in IPMI format, not PPC format */
    unsigned char type;
    union {
        struct {
            unsigned int timestamp_le32;
            BITFIELD2(unsigned char, is_swid : 1, addr_swid : 7);
            BITFIELD3(unsigned char, lun : 2, _res1 : 2, chan : 4);
            unsigned char rev;
            unsigned char sensor_type;
            unsigned char sensor_no;
            BITFIELD2(unsigned char, event_type : 7, event_dir : 1);
            unsigned char event_data[3];
        } __attribute__ ((packed)) sys;
        struct {
            unsigned int timestamp_le32;
            unsigned int man_id_le24 : 24;
            unsigned char oem[6];
        } __attribute__ ((packed)) oem_ts;
        struct {
            unsigned char oem[13];
        } __attribute__ ((packed)) oem_nts;
    }  __attribute__ ((packed));
} __attribute__ ((packed));
typedef struct sel_entry_s sel_entry_t;


#endif
