/**
 * \file debug.h
 *
 * Description: Logging Macros
 *
 * (c) 2004 Peppercon AG, Georg Hoesch <geo@peppercon.de>
 */

#ifndef _PP_BMC_DEBUG_H_
#define _PP_BMC_DEBUG_H_
#include <stdarg.h>
#include <sys/time.h>
#include <time.h>

/**
 * Debugging can be controlled with the following compiler switches 
 *
 * PP_BMC_DEBUG_LEVEL xx   enable debugging on level xx
 *                         higher lovlevel = more messages
 *                         debugging is disabled if undefined
 *   8  debug
 *   7  info
 *   6  notice
 *   5  warn
 *   4  error
 *   3  critical
 *   2  alert
 *   1  fatal
 *   0  disable debugging
 */

#ifdef PP_BUILD_TYPE_FINAL
#  ifdef PP_BMC_DEBUG_LEVEL
#    undef PP_BMC_DEBUG_LEVEL
#  endif
#  define PP_BMC_DEBUG_LEVEL 5
#else 
#  ifndef  PP_BMC_DEBUG_LEVEL
#    define PP_BMC_DEBUG_LEVEL 5
#  endif
#endif


#define PP_BMC_LOG_DEBUG    8
#define PP_BMC_LOG_INFO     7
#define PP_BMC_LOG_NOTICE   6
#define PP_BMC_LOG_WARN     5
#define PP_BMC_LOG_ERROR    4
#define PP_BMC_LOG_CRITICAL 3
#define PP_BMC_LOG_ALERT    2
#define PP_BMC_LOG_FATAL    1

/** Don't use this macro directly */
#if PP_BMC_DEBUG_LEVEL>=1

void pp_bmc_vlog(int level, const char* format, va_list ap);
void pp_bmc_log(int level, const char* format, ...);
void pp_bmc_plog(int lovel, const char* format, ...);

#endif

#if PP_BMC_DEBUG_LEVEL>=8
#define pp_bmc_log_debug(logstring, args...) \
    pp_bmc_log(PP_BMC_LOG_DEBUG, logstring, ##args)
#define pp_bmc_log_pdebug(logstring, args...) \
    pp_bmc_plog(PP_BMC_LOG_DEBUG, logstring, ##args)
#else
#define pp_bmc_log_debug(logstring, args...)
#define pp_bmc_log_pdebug(logstring, args...)
#endif

#if PP_BMC_DEBUG_LEVEL>=7
#define pp_bmc_log_info(logstring, args...) \
    pp_bmc_log(PP_BMC_LOG_INFO, logstring, ##args)
#define pp_bmc_log_pinfo(logstring, args...) \
    pp_bmc_plog(PP_BMC_LOG_INFO, logstring, ##args)
#else
#define pp_bmc_log_info(logstring, args...)
#define pp_bmc_log_pinfo(logstring, args...)
#endif

#if PP_BMC_DEBUG_LEVEL>=6
#define pp_bmc_log_notice(logstring, args...)  \
    pp_bmc_log(PP_BMC_LOG_NOTICE, logstring, ##args)
#define pp_bmc_log_pnotice(logstring, args...) \
    pp_bmc_plog(PP_BMC_LOG_NOTICE, logstring, ##args)
#else
#define pp_bmc_log_notice(logstring, args...)
#define pp_bmc_log_pnotice(logstring, args...)
#endif

#if PP_BMC_DEBUG_LEVEL>=5
#define pp_bmc_log_warn(logstring, args...) \
    pp_bmc_log(PP_BMC_LOG_WARN, logstring, ##args)
#define pp_bmc_log_pwarn(logstring, args...) \
    pp_bmc_plog(PP_BMC_LOG_WARN, logstring, ##args)
#else
#define pp_bmc_log_warn(logstring, args...)
#define pp_bmc_log_pwarn(logstring, args...)
#endif

#if PP_BMC_DEBUG_LEVEL>=4
#define pp_bmc_log_error(logstring, args...) \
    pp_bmc_log(PP_BMC_LOG_ERROR, logstring, ##args)
#define pp_bmc_log_perror(logstring, args...) \
    pp_bmc_plog(PP_BMC_LOG_ERROR, logstring, ##args)
#else
#define pp_bmc_log_error(logstring, args...)
#define pp_bmc_log_perror(logstring, args...)
#endif

#if PP_BMC_DEBUG_LEVEL>=3
#define pp_bmc_log_critical(logstring, args...) \
    pp_bmc_log(PP_BMC_LOG_CRITICAL, logstring, ##args)
#define pp_bmc_log_pcritical(logstring, args...) \
    pp_bmc_plog(PP_BMC_LOG_CRITICAL, logstring, ##args)
#else
#define pp_bmc_log_critical(logstring, args...)
#define pp_bmc_log_pcritical(logstring, args...)
#endif

#if PP_BMC_DEBUG_LEVEL>=2
#define pp_bmc_log_alert(logstring, args...) \
    pp_bmc_log(PP_BMC_LOG_ALERT, logstring, ##args)
#define pp_bmc_log_palert(logstring, args...) \
    pp_bmc_plog(PP_BMC_LOG_ALERT, logstring, ##args)
#else
#define pp_bmc_log_alert(logstring, args...)
#define pp_bmc_log_palert(logstring, args...)
#endif

#if PP_BMC_DEBUG_LEVEL>=1
#define pp_bmc_log_fatal(logstring, args...) \
    pp_bmc_log(PP_BMC_LOG_FATAL, logstring, ##args)
#define pp_bmc_log_pfatal(logstring, args...) \
    pp_bmc_plog(PP_BMC_LOG_FATAL, logstring, ##args)
#else
#define pp_bmc_log_fatal(logstring, args...)
#define pp_bmc_log_pfatal(logstring, args...)
#endif

void pp_bmc_printbuf(const unsigned char* prefix,
                     const unsigned char* buf, int buf_len);

#endif

