/**
 * ipmi_cmd_sensor.h
 *
 * selected sensor device cmd structures,
 * those are defined here so the the sensor driver routines
 * can use 'em.
 * This list is not complete! Add command structures as necessary.
 * 
 * (c) 2004 Peppercon AG, 12/14/2004, tbr@peppecon.de
 */

#ifndef __IPMI_CMD_SENSOR_H__
#define __IPMI_CMD_SENSOR_H__

#include <pp/bmc/utils.h>

#define IPMI_SENSOR_THRESHOLD_LOWER_NON_CRIT    ((unsigned char)(1 << 0))
#define IPMI_SENSOR_THRESHOLD_LOWER_CRIT        ((unsigned char)(1 << 1))
#define IPMI_SENSOR_THRESHOLD_LOWER_NON_RECOV   ((unsigned char)(1 << 2))
#define IPMI_SENSOR_THRESHOLD_UPPER_NON_CRIT    ((unsigned char)(1 << 3))
#define IPMI_SENSOR_THRESHOLD_UPPER_CRIT        ((unsigned char)(1 << 4))
#define IPMI_SENSOR_THRESHOLD_UPPER_NON_RECOV   ((unsigned char)(1 << 5))

#define IPMI_SENSOR_EVENT_LOWER_NON_CRIT_GOING_LO   ((unsigned short)(1 << 0))
#define IPMI_SENSOR_EVENT_LOWER_NON_CRIT_GOING_HI   ((unsigned short)(1 << 1))
#define IPMI_SENSOR_EVENT_LOWER_CRIT_GOING_LO       ((unsigned short)(1 << 2))
#define IPMI_SENSOR_EVENT_LOWER_CRIT_GOING_HI       ((unsigned short)(1 << 3))
#define IPMI_SENSOR_EVENT_LOWER_NON_RECOV_GOING_LO  ((unsigned short)(1 << 4))
#define IPMI_SENSOR_EVENT_LOWER_NON_RECOV_GOING_HI  ((unsigned short)(1 << 5))
#define IPMI_SENSOR_EVENT_UPPER_NON_CRIT_GOING_LO   ((unsigned short)(1 << 6))
#define IPMI_SENSOR_EVENT_UPPER_NON_CRIT_GOING_HI   ((unsigned short)(1 << 7))
#define IPMI_SENSOR_EVENT_UPPER_CRIT_GOING_LO       ((unsigned short)(1 << 8))
#define IPMI_SENSOR_EVENT_UPPER_CRIT_GOING_HI       ((unsigned short)(1 << 9))
#define IPMI_SENSOR_EVENT_UPPER_NON_RECOV_GOING_LO  ((unsigned short)(1 << 10))
#define IPMI_SENSOR_EVENT_UPPER_NON_RECOV_GOING_HI  ((unsigned short)(1 << 11))

#define IPMI_SENSOR_EVENT_STATE_BIT0    ((unsigned short)(1 << 0))
#define IPMI_SENSOR_EVENT_STATE_BIT1    ((unsigned short)(1 << 1))
#define IPMI_SENSOR_EVENT_STATE_BIT2    ((unsigned short)(1 << 2))
#define IPMI_SENSOR_EVENT_STATE_BIT3    ((unsigned short)(1 << 3))
#define IPMI_SENSOR_EVENT_STATE_BIT4    ((unsigned short)(1 << 4))
#define IPMI_SENSOR_EVENT_STATE_BIT5    ((unsigned short)(1 << 5))
#define IPMI_SENSOR_EVENT_STATE_BIT6    ((unsigned short)(1 << 6))
#define IPMI_SENSOR_EVENT_STATE_BIT7    ((unsigned short)(1 << 7))
#define IPMI_SENSOR_EVENT_STATE_BIT8    ((unsigned short)(1 << 8))
#define IPMI_SENSOR_EVENT_STATE_BIT9    ((unsigned short)(1 << 9))
#define IPMI_SENSOR_EVENT_STATE_BIT10   ((unsigned short)(1 << 10))
#define IPMI_SENSOR_EVENT_STATE_BIT11   ((unsigned short)(1 << 11))
#define IPMI_SENSOR_EVENT_STATE_BIT12   ((unsigned short)(1 << 12))
#define IPMI_SENSOR_EVENT_STATE_BIT13   ((unsigned short)(1 << 13))
#define IPMI_SENSOR_EVENT_STATE_BIT14   ((unsigned short)(1 << 14))
#define IPMI_SENSOR_EVENT_STATE_COUNT	15

#define IPMI_SENSOR_CAPS_EVENT_NONE           0x3
#define IPMI_SENSOR_CAPS_EVENT_GLOBAL_DISABLE 0x2
#define IPMI_SENSOR_CAPS_EVENT_ENTIRE_SENSOR  0x1
#define IPMI_SENSOR_CAPS_EVENT_PER_TRESH      0x0

/**
 * Sensor Hysteresis request/response structures
 */

struct ipmi_set_sensor_hysteresis_rq_s {
    unsigned char sensor_no;
    unsigned char mask; // reserved for future use
    unsigned char pos_going;
    unsigned char neg_going;
} __attribute__ ((packed));
typedef struct ipmi_set_sensor_hysteresis_rq_s
               ipmi_set_sensor_hysteresis_rq_t;

struct ipmi_get_sensor_hysteresis_rs_s {
    unsigned char pos_going;
    unsigned char neg_going;
} __attribute__ ((packed));
typedef struct ipmi_get_sensor_hysteresis_rs_s
               ipmi_get_sensor_hysteresis_rs_t;

/**
 * Sensor Threshold request/response structures
 */

struct ipmi_set_sensor_thresholds_rq_s {
    unsigned char sensor_no;
    unsigned char mask; // see IPMI_SENSOR_THRESHOLD_xxxx
    unsigned char lower_non_crit;
    unsigned char lower_crit;
    unsigned char lower_non_recov;
    unsigned char upper_non_crit;
    unsigned char upper_crit;
    unsigned char upper_non_recov;
} __attribute__ ((packed));
typedef struct ipmi_set_sensor_thresholds_rq_s
               ipmi_set_sensor_thresholds_rq_t;

struct ipmi_get_sensor_thresholds_rs_s {
    unsigned char mask; // see IPMI_SENSOR_THRESHOLD_xxxx
    unsigned char lower_non_crit;
    unsigned char lower_crit;
    unsigned char lower_non_recov;
    unsigned char upper_non_crit;
    unsigned char upper_crit;
    unsigned char upper_non_recov;
} __attribute__ ((packed));
typedef struct ipmi_get_sensor_thresholds_rs_s
               ipmi_get_sensor_thresholds_rs_t;

/**
 * Sensor Event Enable request/response structures
 */

struct ipmi_set_sensor_event_enable_rq_s {
    unsigned char sensor_no;
    BITFIELD5(unsigned char,
              _resv0            : 4,
              enable_events     : 1, // enable all events set in following mask
              disable_events    : 1, // disable all events set in following mask
              scan_enabled      : 1, // sensor scanning enabled
              evts_enabled      : 1  // event generation switch on at all
              );
    unsigned short assertion_events_le16;   // see IPMI_SENSOR_EVENT_xxxx
    unsigned short deassertion_events_le16; // see IPMI_SENSOR_EVENT_xxxx
} __attribute__ ((packed));
typedef struct ipmi_set_sensor_event_enable_rq_s
               ipmi_set_sensor_event_enable_rq_t;

struct ipmi_get_sensor_event_enable_rs_s {
    BITFIELD3(unsigned char,
              _resv0        : 6,
              scan_enabled  : 1,
              evts_enabled  : 1
              );
    unsigned short assertion_events_le16;   // see IPMI_SENSOR_EVENT_xxxx
    unsigned short deassertion_events_le16; // see IPMI_SENSOR_EVENT_xxxx
} __attribute__ ((packed));
typedef struct ipmi_get_sensor_event_enable_rs_s
               ipmi_get_sensor_event_enable_rs_t;

/**
 * Sensor Re-arm request structures
 */

struct ipmi_rearm_sensor_events_rq_s {
    unsigned char sensor_no;
    BITFIELD2(unsigned char,
              _resv0                : 7,
              rearm_only_selected   : 1  // re-arm selected or all events
              );
    unsigned short assertion_events_le16;   // see IPMI_SENSOR_EVENT_xxxx
    unsigned short deassertion_events_le16; // see IPMI_SENSOR_EVENT_xxxx
} __attribute__ ((packed));
typedef struct ipmi_rearm_sensor_events_rq_s
               ipmi_rearm_sensor_events_rq_t;

/**
 * Sensor Status request structures
 */

struct ipmi_sensor_get_event_status_rs_s {
    BITFIELD4(unsigned char,
              _resv0                     : 5,
              unavailable                : 1,
              scan_enabled               : 1,
              evts_enabled               : 1
              );
    unsigned short assertion_events_le16;   // see IPMI_SENSOR_EVENT_xxxx
    unsigned short deassertion_events_le16; // see IPMI_SENSOR_EVENT_xxxx
} __attribute__ ((packed));
typedef struct ipmi_sensor_get_event_status_rs_s
               ipmi_sensor_get_event_status_rs_t;

/**
 * Sensor Reading response structure
 * there are two slightly different version are expressed seperately
 * A union will allow for a single typed function parameter
 */

struct ipmi_sensor_get_reading_threshold_rs_s {
    unsigned char value;
    BITFIELD4(unsigned char,
	      _resv0                     : 5,
	      unavailable                : 1,
	      scan_enabled               : 1,
	      evts_enabled               : 1
	      );
    BITFIELD7(unsigned char,
	      below_lower_non_crit       : 1,
	      below_lower_crit           : 1,
	      below_lower_non_recov      : 1,
	      above_upper_non_crit       : 1,
	      above_upper_crit           : 1,
	      above_upper_non_recov      : 1,
	      _resv1                     : 2
	      );
    unsigned char _resv2;
} __attribute__ ((packed));
typedef struct ipmi_sensor_get_reading_threshold_rs_s
               ipmi_sensor_get_reading_threshold_rs_t;

struct ipmi_sensor_get_reading_discrete_rs_s {
    unsigned char value;
    BITFIELD4(unsigned char,
	      _resv0                     : 5,
	      unavailable                : 1,
	      scan_enabled               : 1,
	      evts_enabled               : 1
	      );
    BITFIELD8(unsigned char,
	      state0                     : 1,
	      state1                     : 1,
	      state2                     : 1,
	      state3                     : 1,
	      state4                     : 1,
	      state5                     : 1,
	      state6                     : 1,
	      state7                     : 1
	      );
    BITFIELD8(unsigned char,
	      state8                     : 1,
	      state9                     : 1,
	      state10                    : 1,
	      state11                    : 1,
	      state12                    : 1,
	      state13                    : 1,
	      state14                    : 1,
	      _resv1                     : 1
	      );
} __attribute__ ((packed));
typedef struct ipmi_sensor_get_reading_discrete_rs_s
               ipmi_sensor_get_reading_discrete_rs_t;

union ipmi_sensor_get_reading_rs_u {
    ipmi_sensor_get_reading_threshold_rs_t rt;
    ipmi_sensor_get_reading_discrete_rs_t  rd;
} __attribute__ ((packed));
typedef union ipmi_sensor_get_reading_rs_u ipmi_sensor_get_reading_rs_t;

/**
 * GetSensorReadingFactors
 */
struct ipmi_get_sensor_reading_factors_rs_s {
    unsigned char next_reading;
    unsigned char m_ls;
    BITFIELD2(unsigned char,
	      m_ms	: 2,
	      tol	: 6
	      );
    unsigned char b_ls;
    BITFIELD2(unsigned char,
	      b_ms	: 2,
	      acc_ls	: 6
	      );
    BITFIELD3(unsigned char,
	      acc_ms    : 4, 
	      acc_exp   : 2,
	      _resv0    : 2
	      );
    BITFIELD2(unsigned char,
	      r_exp     : 4,
	      b_exp     : 4
	      );
} __attribute__ ((packed));
typedef struct ipmi_get_sensor_reading_factors_rs_s
	       ipmi_get_sensor_reading_factors_rs_t;

#endif
