/**
 * \file ipmi_err.h
 *
 * Description: IPMI Completion Codes
 *
 * (c) 2004 Peppercon AG, Ralf Guenther <rgue@peppercon.de>
 */

#ifndef __IPMI_ERR_H__
#define __IPMI_ERR_H__

#define IPMI_SUCCEEDED(err) ((err) == IPMI_ERR_SUCCESS)
#define IPMI_FAILED(err)    ((err) != IPMI_ERR_SUCCESS)

/* Caution: err is evaluated twice! */
#define IPMI_IS_DEVICE_ERR(err)  ((err) >= 0x01 && (err) <= 0x7E)
#define IPMI_IS_COMMAND_ERR(err) ((err) >= 0x80 && (err) <= 0xBE)
#define IPMI_IS_GENERIC_ERR(err) ((err) >= 0xC0 && (err) <= 0xFF)
 
/*
 * Generic completion codes for IPMI.
 */
 
#define IPMI_ERR_SUCCESS                        0x00
#define IPMI_ERR_NODE_BUSY                      0xC0
#define IPMI_ERR_INVALID_CMD                    0xC1
#define IPMI_ERR_COMMAND_INVALID_FOR_THIS_LUN   0xC2
#define IPMI_ERR_TIMEOUT                        0xC3
#define IPMI_ERR_OUT_OF_SPACE                   0xC4
#define IPMI_ERR_INVALID_RESERVATION            0xC5
#define IPMI_ERR_REQ_DATA_TRUNC                 0xC6
#define IPMI_ERR_REQ_DATA_LEN_INVALID           0xC7
#define IPMI_ERR_REQ_DATA_LEN_LIMIT_EXCEEDED    0xC8
#define IPMI_ERR_PARAM_OUT_OF_RANGE             0xC9
#define IPMI_ERR_CANNOT_RETURN_DATA_SIZE        0xCA
#define IPMI_ERR_ITEM_NOT_PRESENT               0xCB
#define IPMI_ERR_INVALID_DATA_FIELD             0xCC
#define IPMI_ERR_CMD_ILLEGAL_FOR_THIS_ITEM      0xCD
#define IPMI_ERR_COULD_NOT_PROVIDE_RESP         0xCE
#define IPMI_ERR_CANNOT_EXEC_DUPLICATE_REQ      0xCF
#define IPMI_ERR_SDR_REPO_IN_UPDATE_MODE        0xD0
#define IPMI_ERR_DEV_IN_FIRMWARE_UPDATE_MODE    0xD1
#define IPMI_ERR_BMC_INIT_IN_PROGRESS           0xD2
#define IPMI_ERR_DEST_UNAVAILABLE               0xD3
#define IPMI_ERR_INSUFFICIENT_PRIVILEGE_LEVEL   0xD4
#define IPMI_ERR_NOT_SUPPORTED_IN_PRESENT_STATE 0xD5
#define IPMI_ERR_ILLEGAL_PARAMETER_IN_SUB_FUNC  0xD6
#define IPMI_ERR_UNSPECIFIED                    0xff

/*
 * Device completion codes for IPMI.
 */

/*
 * Generic bmccore completion codes
 */
#define IPMI_ERR_BAD_SEL_TYPE                       0x80
#define IPMI_ERR_SEL_BUSY                           0x81

#define IPMI_ERR_DATA_NOT_AVAIL                     0x80

#define IPMI_ERR_BAD_PASSWD                         0x80
#define IPMI_ERR_BAD_PASSWD_SIZE                    0x81

#define IPMI_ERR_EVENT_MSG_BUFFER_EMPTY             0x80

/*
 * Session challenge/activation completion codes
 */
#define IPMI_ERR_SESSION_INVALID_USERNAME           0x81
#define IPMI_ERR_SESSION_NO_ANONYMOUS_USER          0x82

#define IPMI_ERR_SESSION_NO_SLOT                    0x81
#define IPMI_ERR_SESSION_NO_USER_SLOT               0x82
#define IPMI_ERR_SESSION_NO_PRIVILEGE_SLOT          0x83
#define IPMI_ERR_SESSION_WRONG_SEQUENCE_NO          0x84
#define IPMI_ERR_SESSION_INVALID_SESSION_ID         0x85
#define IPMI_ERR_SESSION_PRIVILEGE_EXCEEDED         0x86

#define IPMI_ERR_SESSION_SET_PRIV_NOT_AVAIL         0x80
#define IPMI_ERR_SESSION_REQ_PRIVILEGE_EXCEEDED     0x81

#define IPMI_ERR_SESSION_CLOSE_NOT_EXISTING         0x87

#define IPMI_ERR_SESSION_AUTH_FAILED                0x88    // SCSI specific

/*
 * LAN payload cmd completion codes
 */
#define IPMI_ERR_PAYLOAD_ACT_ALREADY_ACTIVE         0x80
#define IPMI_ERR_PAYLOAD_ACT_DISABLED               0x81
#define IPMI_ERR_PAYLOAD_ACT_LIMIT_REACHED          0x82
#define IPMI_ERR_PAYLOAD_ACT_NOT_WITH_ENCRYPTION    0x83
#define IPMI_ERR_PAYLOAD_ACT_NOT_WITHOUT_ENCRYPTION 0x84

#define IPMI_ERR_PAYLOAD_DEACT_NOT_ACTIVE           0x80
#define IPMI_ERR_PAYLOAD_DEACT_DISABLED             0x81

#define IPMI_ERR_PAYLOAD_TYPE_NOT_AVAILABLE         0x80

/*
 * LAN config parameters completion code
 */
#define IPMI_ERR_LANCONF_PARAM_NOT_SUPPORTED        0x80
#define IPMI_ERR_LANCONF_SET_IN_PROGRESS            0x81
#define IPMI_ERR_LANCONF_READ_ONLY                  0x82

/*
 * SOL config parameters completion code
 */
#define IPMI_ERR_SOL_CFG_PARAM_NOT_SUPPORTED        0x80
#define IPMI_ERR_SOL_CFG_SET_IN_PROGRESS            0x81
#define IPMI_ERR_SOL_CFG_READ_ONLY                  0x82

/*
 * Serial / Modem config parameters completion code
 */
#define IPMI_ERR_SERIAL_MODEM_PARAM_NOT_SUPPORTED       0x80
#define IPMI_ERR_SERIAL_MODEM_SET_IN_PROGRESS           0x81
#define IPMI_ERR_SERIAL_MODEM_READ_ONLY                 0x82
#define IPMI_ERR_SERIAL_MODEM_WRITE_ONLY                0x82

/*
 * Get/Set channel access completion code
 */
#define IPMI_ERR_APP_CHANNEL_SINGLE_SESSION             0x82
#define IPMI_ERR_APP_CHANNEL_ACCESS_MODE_NOT_SUPPORTED  0x83

/*
 * PEF alert immediate command completion codes
 */
#define IPMI_ERR_PEF_PARAM_NOT_SUPPORTED                0x80
#define IPMI_ERR_PEF_SET_IN_PROGRESS                    0x81
#define IPMI_ERR_PEF_PARAM_READ_ONLY                    0x82
#define IPMI_ERR_PEF_PARAM_WRITE_ONLY                   0x83
#define IPMI_ERR_PEF_ALERT_IN_PROGRESS                  0x81
#define IPMI_ERR_PEF_IPMI_MESSAGING_ACTIVE              0x82

/*
 * Chassis set/get system boot options completion codes
 */
#define IPMI_ERR_CHA_PARAM_NOT_SUPPORTED   0x80
#define IPMI_ERR_CHA_SET_IN_PROGRESS       0x81
#define IPMI_ERR_CHA_READ_ONLY             0x82


#endif /* !__IPMI_ERR_H__ */
