/**
 * ipmi_fru.h
 *
 * some incomplete structures for the 
 * IPMI Platform Management FRU Information Storage Definition
 * 
 * FRU header (ftp://download.intel.com/design/servers/ipmi/FRU1011.pdf)
 *
 * (c) 2005 Peppercon AG, 2005/6/21, tbr@peppecon.de
 */

struct ipmi_fru_header_s {
    BITFIELD2(unsigned char, version : 4, reserved : 4);
    struct {
        unsigned char internal;
        unsigned char chassis;
        unsigned char board;
        unsigned char product;
        unsigned char multi;
    } __attribute__ ((packed)) offset;
    unsigned char pad;
    unsigned char checksum;
} __attribute__ ((packed));
typedef struct ipmi_fru_header_s ipmi_fru_header_t;

struct ipmi_fru_chassis_info_s {
    BITFIELD2(unsigned char, \
	      version : 4,   \
	      rsvd : 4);
    unsigned char length;
    unsigned char type;
    BITFIELD2(unsigned char,          \
	      part_number_length : 6, \
	      part_number_type : 2);
    unsigned char part_number[0];
    // more to come here, what we are not interested in, currently
} __attribute__ ((packed));
typedef struct ipmi_fru_chassis_info_s ipmi_fru_chassis_info_t;
    
    

#define IPMI_FRU_HEADER_VER  0x1
