/**
 * \file ipmi_str.h
 *
 * Description: IPMI Codes to Strings 
 *              (many functions implemented in string.c taken form OpenIPMI)
 *
 * (c) 2004 Peppercon AG, Ralf Guenther <rgue@peppercon.de>
 */

#ifndef __IPMI_STR_H__
#define __IPMI_STR_H__

/* New (self made) functions */

const char* ipmi_get_privilege_level_string(unsigned char priv_level);
const char* ipmi_get_completion_code_string(unsigned char compl_code);

/* Functions from OpenIPMI */

// TODO create real definitions
enum ipmi_update_e { IPMI_ADDED, IPMI_DELETED, IPMI_CHANGED };
#define IPMI_EVENT_READING_TYPE_SENSOR_SPECIFIC 0x6f
enum ipmi_thresh_e { x1 };
enum ipmi_event_value_dir_e { x2 };
enum ipmi_event_dir_e { x3 };
#include "pp/bmc/ipmi_cmd.h"
#define IPMI_CHASSIS_NETFN      IPMI_NETFN_CHASSIS
#define IPMI_BRIDGE_NETFN       IPMI_NETFN_BRIDGE
#define IPMI_SENSOR_EVENT_NETFN IPMI_NETFN_SENSOR_EVENT
#define IPMI_APP_NETFN          IPMI_NETFN_APP
#define IPMI_FIRMWARE_NETFN     IPMI_NETFN_FIRMWARE
#define IPMI_STORAGE_NETFN      IPMI_NETFN_STORAGE
#define IPMI_TRANSPORT_NETFN    IPMI_NETFN_TRANSPORT
#define IPMI_HOT_SWAP_NOT_PRESENT               1
#define IPMI_HOT_SWAP_INACTIVE                  2
#define IPMI_HOT_SWAP_ACTIVATION_REQUESTED      3
#define IPMI_HOT_SWAP_ACTIVATION_IN_PROGRESS    4
#define IPMI_HOT_SWAP_ACTIVE                    5
#define IPMI_HOT_SWAP_DEACTIVATION_REQUESTED    6
#define IPMI_HOT_SWAP_DEACTIVATION_IN_PROGRESS  7
#define IPMI_HOT_SWAP_OUT_OF_CON                8
enum ipmi_hot_swap_states { x4 };
enum ipmi_domain_type { x5 };

const char* ipmi_update_e_string(enum ipmi_update_e val);

const char* ipmi_get_hysteresis_support_string(unsigned int val);

const char* ipmi_get_threshold_access_support_string(unsigned int val);

const char* ipmi_get_event_support_string(unsigned int val);

const char* ipmi_get_sensor_type_string(unsigned int val);

const char* ipmi_get_event_reading_type_string(unsigned int val);

const char* ipmi_get_sensor_direction_string(unsigned int val);

const char* ipmi_get_rate_unit_string(unsigned int val);

const char* ipmi_get_unit_type_string(unsigned int val);

const char* ipmi_get_threshold_string(enum ipmi_thresh_e val);

const char* ipmi_get_value_dir_string(enum ipmi_event_value_dir_e val);

const char* ipmi_get_event_dir_string(enum ipmi_event_dir_e val);

const char* ipmi_get_entity_id_string(unsigned int val);

const char* ipmi_get_reading_name(unsigned int event_reading_type,
		      unsigned int sensor_type,
		      unsigned int val);

const char* ipmi_get_control_type_string(unsigned int val);

const char* ipmi_get_color_string(unsigned int val);

/*
 * Convert a NetFN code into a string
 */
const char* ipmi_get_netfn_string(unsigned int netfn,
		      char         *buffer,
		      unsigned int buf_len);
/*
 * Convert a NetFN/Command code into a string
 */
const char* ipmi_get_command_string(unsigned int netfn,
			unsigned int cmd,
			char         *buffer,
			unsigned int buf_len);
/*
 * Convert a Completion Code into a string
 */
const char* ipmi_get_cc_string(unsigned int cc,
		   char         *buffer,
		   unsigned int buf_len);

/* Get a string name fo the hot swap state. */
const char* ipmi_hot_swap_state_name(enum ipmi_hot_swap_states state);

const char* ipmi_domain_get_type_string(enum ipmi_domain_type dtype);
      
#endif /* !__IPMI_STR_H__ */

