/**
 * utils.h
 *
 * Description: Commonly Used Utilities
 *
 * (c) 2004 Peppercon AG, Ralf Guenther <rgue@peppercon.de>
 */

#ifndef __UTILS_H__
#define __UTILS_H__

#include <endian.h>
#include <sys/stat.h>
#include "pp/bmc/bmc_imsg.h"


/* bmc file operation convenience functions */
#define S_RWXRWXRWX (S_IRWXU | S_IRWXG | S_IRWXO)
#define S_RW_RW_RW_ (S_IRUSR | S_IWUSR | S_IRGRP | S_IWGRP | S_IROTH | S_IWOTH)

char *getdirname(const char* path); /* return value must be freed! */
int mkdir_recurse(const char* path, mode_t mode);


/* generic ipmi reservation magic */
typedef struct reserv_s reserv_t;
reserv_t* reserv_new(void);
void reserv_delete(reserv_t* r);
unsigned short reserv_make(reserv_t* r, const imsg_t *imsg);
void reserv_cancel(reserv_t* r);
int reserv_check(const reserv_t* r, unsigned short reserv_id,
		 int mandatory, const imsg_t *imsg);
#define PP_BMC_RESERV_OPTIONAL  0
#define PP_BMC_RESERV_MANDATORY 1


/**
 * Convert a privilege level string value from the config system to the
 * corresponding numeric value.
 */
unsigned char pp_bmc_get_privlevel_value(const char* priv_level_string);

/**
 * Convert a numeric privilege level to its String value in the config system.
 */
const char* pp_bmc_get_privlevel_string(unsigned char priv_level);


/**
 * Calculate the ipmi checksum used in many channel message formats.
 * Checksum is calculated over buffer[begin:end] where begin and end
 * are indexes.
 */
unsigned char pp_bmc_calc_ipmi_checksum(unsigned char* buffer, int begin, int end);


/**
 * Write the bmc's GUID to the specified destination.
 * guid_dest must be at least 16 bytes long.
 */
void pp_bmc_get_guid(unsigned char* guid_dest);

#endif /* !__UTILS_H__ */
