/**
 * nc_interrupt.c
 *
 * Non communication interrupt module. This module collects all
 * non communication interrupts (Receive Message Queue, Event Message
 * Queue, Watchdog Pretimeout) and forwards the status accordingly.
 * Depending on the status the SMS_ATN bit in the system interface
 * is set.
 *
 * Notes:
 * OEM interrupt flags are not covered.
 * Disabling the receive_msg_queue interrupt is not supported by ipmi.
 * 
 * (c) 2005 Peppercon AG, Georg Hoesch <geo@peppercon.de>
 */
 
#include "nc_interrupt.h"
#include <pp/bmc/debug.h>
#include <pp/bmc/bmc_router.h>

static unsigned char int_val = 0;   // current status of interrupt (asserted/deasserted)
static unsigned char interrupt_flag[3] = { 0, 0, 0 };
static unsigned char interrupt_enable[3] = { 1, 1, 1 };

static void check_int_flags(void) {
    unsigned char int_new;
    int i;
    
    int_new = 0;
    for (i=0; i<3; i++) {
        if (interrupt_enable[i] == 1) {
            if (interrupt_flag[i] == 1) {
                int_new = 1;
            }
        }
    }
    
    if (int_val != int_new) {
        pp_bmc_router_set_nc_interrupt(int_new);
    }
    int_val = int_new;
}

void bmc_interrupt_flag_set(bmc_interrupt_t interrupt, unsigned char value) {
    interrupt_flag[interrupt] = value;
    check_int_flags();
}  

unsigned char bmc_interrupt_flag_get(bmc_interrupt_t interrupt) {
    return interrupt_flag[interrupt];
}

void bmc_interrupt_enable_set(bmc_interrupt_t interrupt, unsigned char value) {
    interrupt_enable[interrupt] = value;
    check_int_flags();
}        

unsigned char bmc_interrupt_enable_get(bmc_interrupt_t interrupt) {
    return interrupt_enable[interrupt];
}    

