/**
 * nc_interrupt.h
 *
 * Non communication interrupt module. This module collects all
 * non communication interrupts (Receive Message Queue, Event Message
 * Queue, Watchdog Pretimeout) and forwards the status accordingly.
 * Depending on the status the SMS_ATN bit in the system interface
 * is set.
 * 
 * Notes:
 * OEM interrupt flags are not covered.
 * Disabling the receive_msg_queue interrupt is not supported by ipmi.
 * 
 * (c) 2005 Peppercon AG, Georg Hoesch <geo@peppercon.de>
 */

#ifndef __BMC_NC_INTERRUPT_H__
#define __BMC_NC_INTERRUPT_H__

typedef enum {
    BMC_INTERRUPT_RECEIVE_MSG_QUEUE,
    BMC_INTERRUPT_EVENT_MSG_BUFFER,
    BMC_INTERRUPT_WATCHDOG_PRETIMEOUT
} bmc_interrupt_t;


/**
 * Set the status of the associated interrupt to 0 (deasserted) or 1 (asserted).
 */
void bmc_interrupt_flag_set(bmc_interrupt_t interrupt, unsigned char value);

/**
 * Get the status of the assiciated interrupt flag.
 */
unsigned char bmc_interrupt_flag_get(bmc_interrupt_t interrupt);


/**
 * Enable or disable the generation of an interrupt associated with the
 * specified flag. If interrupt generation is disabled, then setting the
 * flag to 1 will not generate an interrupt.
 */
void bmc_interrupt_enable_set(bmc_interrupt_t interrupt, unsigned char value);

/**
 * Get the interrupt enable status for the specified flag.
 */
unsigned char bmc_interrupt_enable_get(bmc_interrupt_t interrupt);


#endif
