/**
 * misc.c
 *
 * (c) 2005 Peppercon AG, Georg Hoesch <geo@peppercon.de>
 *
 * Miscellaneous bmc hardware related functions
 */

#include <pp/bmc/bmc_health.h>

static unsigned char bmc_health[BMC_HEALTH_MAX_INDEX];
static unsigned char bmc_health_initialized = 0;

static void initialize_bmc_health(void) {
    if (bmc_health_initialized == 0) {
        memset(bmc_health, 0, BMC_HEALTH_MAX_INDEX);
        bmc_health_initialized = 1;
    }
}

unsigned char pp_bmc_health_get_fault(int idx) {
    initialize_bmc_health();
    return bmc_health[idx];
}

void pp_bmc_health_report_fault(int idx) {
    initialize_bmc_health();
    bmc_health[idx] = 1;
}

int pp_bmc_health_check() {
    int i;
    initialize_bmc_health();
    
    for (i=0; i<BMC_HEALTH_MAX_INDEX; i++)
        if (bmc_health[i] == 1)
            return PP_ERR;
    return PP_SUC;
}

