/**
 * misc.h
 *
 * (c) 2005 Peppercon AG, Georg Hoesch <geo@peppercon.de>
 *
 * Miscellaneous bmc hardware related functions
 */


#ifndef __BMC_HW_MISC_H__
#define __BMC_HW_MISC_H__

#include <pp/base.h>

/**
 * bmc health status defines. Each entry contains the index of a
 * boolean value (currently char) that can be set to 1 to indicate
 * that the specified part of the bmc is not initialized/working
 * properly
 */

enum bmc_health_status_type {
    /* predefined status bits */
    BMC_HEALTH_SEL_ACCESS	= 0,
    BMC_HEALTH_SDR_ACCESS	= 1,
    BMC_HEALTH_FRU_ACCESS	= 2,
    BMC_HEALTH_IPBM_ACCESS	= 3,
    BMC_HEALTH_SDR_EMPTY	= 4,
    BMC_HEALTH_FRU_CORRUPT	= 5,
    BMC_HEALTH_BOOT_CORRUPT	= 6,
    BMC_HEALTH_FIRMWARE_CORRUPT	= 7,

    /* pp-specific defines */
    BMC_HEALTH_LAN_CHAN,
    BMC_HEALTH_SI_CHAN,
    BMC_HEALTH_SERIAL_CHAN,
    BMC_HEALTH_PRIM_IPMB_CHAN,
    BMC_HEALTH_SECO_IPMB_CHAN,
    BMC_HEALTH_LOOPI_CHAN,
    BMC_HEALTH_SCSI_CHAN,

    BMC_HEALTH_APP_DEV,
    BMC_HEALTH_FRU_DEV,
    BMC_HEALTH_SEL_DEV,
    BMC_HEALTH_SDRR_DEV,
    BMC_HEALTH_SENSOR_DEV,
    BMC_HEALTH_WATCHDOG_DEV,
    BMC_HEALTH_KVM_DEV,
    BMC_HEALTH_PEF_DEV,
    BMC_HEALTH_SESSION_DEV,
    BMC_HEALTH_CHASSIS_DEV,
    BMC_HEALTH_OEM_MSI_DEV,
    BMC_HEALTH_EVENT_DEV,
    BMC_HEALTH_OEM_AMD_DEV,
    BMC_HEALTH_OEM_ICP_DEV,
    BMC_HEALTH_OEM_PP_DEV,
    BMC_HEALTH_OEM_PP_RPC_DEV,
    BMC_HEALTH_OEM_SUPERMICRO_DEV,
    BMC_HEALTH_OEM_RACKABLE_DEV,
    BMC_HEALTH_OEM_PP_SELFTEST_DEV,

    BMC_HEALTH_MAX_INDEX
};

/**
 * Query if the specified aspect of the bmc is faulty.
 * @returns 0 if part works correct
 * @returns 1 if part has reported errors
 */
unsigned char pp_bmc_health_get_fault(int idx);

/**
 * Notify the bmc that the specified part of the bmc is not
 * working correctly (this usually happens during initialization).
 * Note that the error notification is cleared only on reset.
 */
void pp_bmc_health_report_fault(int idx);

#if defined(PP_FEAT_BMC_OEMCMDS_ONLY)
#define BMC_HEALTH_REPORT_FAULT(x) 
#else
#define BMC_HEALTH_REPORT_FAULT(x) pp_bmc_health_report_fault(x)
#endif

/**
 * Check if every part of the bmc works correct.
 * @returns PP_SUC if bmc is healty
 * @returns PP_ERR if there are one or several problems in the bmc
 */
int pp_bmc_health_check(void);


#endif
