/**
 * host_i2c_access.h
 *
 * Implements Supermicro's I2C access control.
 *
 * I2C access has to be synchronized between BIOS and BMC. After
 * Power On or Reset, BIOS should have control. Additionally,
 * there are OEM cmd to allow BIOS to manually request/release control.
 *
 * (c) 2006 Peppercon AG, Ralf Guenther <rgue@peppercon.de>
 */

#ifndef _PP_BMC_HARDWARE_I2C_ACCESS_H
#define _PP_BMC_HARDWARE_I2C_ACCESS_H

/**
 * Init the host_i2c_access module, called by bmc_host_hardware_init()
 */
int pp_bmc_host_i2c_access_init(void);

/**
 * Cleanup the host_i2c_access module, called by bmc_host_hardware_cleanup()
 */
void pp_bmc_host_i2c_access_cleanup(void);

/**
 * Allows the BMC to access the I2C.
 */
int pp_bmc_host_i2c_access_enable(void);

/**
 * Prohibit any I2C operation done by BMC (BIOS has control).
 * (has a timeout of 30secs!)
 */
int pp_bmc_host_i2c_access_disable(void);

/**
 * Returns the status of I2C access.
 * @return 0 if BIOS has I2C control
 * @return 1 if BMC has I2C control
 */
int pp_bmc_host_i2c_access_get_state(void);

#endif /* _PP_BMC_HARDWARE_I2C_ACCESS_H */
