/**
 * rpc_host_board_id.c
 * 
 * detect type of RPC, i.e. number of relay controller boards
 *
 * (c) 2006 Peppercon AG, 2005/04/12 tbr@peppercon.de
 */

#include <pp/base.h>
#include <pp/i2c.h>
#include <pp/cfg.h>
#include <pp/bmc/debug.h>
#include <pp/bmc/host_board_id.h>
#include <pp/bmc/rpc_host_board_id.h>
#include <pp/hal_rpc.h>

#define I2C_BUS_DEV     "faraday-1"
#define I2C_FIRST_ADDR  0x20
#define I2C_LAST_ADDR   0x2b

/*
 * rpc board id checks config system.
 * if model string is found, it will be mapped to topo-id
 * and number of outlets.
 * Additionally i2c-bus will be scanned and checked against
 * configured number of outlets.
 */
void rpc_host_board_id_get(pp_bmc_host_board_id_t* bid) {
    const char *topo = pp_hal_rpc_get_topo();

    if (!topo) {
	bid->id_type = HOST_BOARD_ID_TYPE_UNDEFINED;
	bid->id_length = 0;
    } else {
	bid->id_type = HOST_BOARD_ID_TYPE_RPC;
        bid->id_length = strlen(topo);
        strcpy(bid->id_value, topo);
    }
    
    return;
}

