/**
 * ipmi_lan.h
 *
 * (c) 2005 Peppercon AG, Georg Hoesch <geo@peppercon.de>
 *
 * General lanchannel specific definitions.
 */

#ifndef __IPMI_LAN_H__
#define __IPMI_LAN_H__

#include <pp/bmc/lan_lowlevel.h>


// lan-channel specific data for ipmi messages
typedef struct {
    struct sockaddr addr;
    socklen_t addr_len;
    
    unsigned char ipmi_version;   // 0x51 for v15 or 0x02 for v20, used only for returning anonymous
                                  // messages with session == NULL. Version of other messages can be
                                  // determined with session->authtype
    unsigned char msg_unauth;     // Set to 1 if the message was sent unauthenticated within a session.
                                  // (reasons may be no_user_auth, no_msg_auth flags) to return a
                                  // corresponding unauthenticated message. Usually this flag is 0.
} lan_addr_t;


/* RMCP class */
#define RMCP_CLASS_ASF  0x06
#define RMCP_CLASS_IPMI 0x07

/* lan_addr_t.ipmiversion */
#define IPMI_LAN_VERSION_15   0x51
#define IPMI_LAN_VERSION_20   0x02


#endif
