/**
 * lan_serv.h
 *
 * (c) 2005 Peppercon AG, Georg Hoesch <geo@peppercon.de>
 *
 * A lan channel adapter for the pp_bmc_core.
 */

#ifndef __LAN_SERV_H__
#define __LAN_SERV_H__

#include <netinet/in.h>
#include <pp/bmc/bmc_imsg.h>
#include <pp/bmc/lan_lowlevel.h>
#include <pp/bmc/ipmi_lan.h>


#define IPMI_LAN_PORT 623


/**
 * Init the lanserver and all subcomponents
 */
int pp_bmc_lanserv_init(void);

/**
 * Cleanup the lanserver and all subcomponents
 */
void pp_bmc_lanserv_cleanup(void);


/**
 * Returns pointer to the socket address information stored in a given session
 *
 * @param session desired session
 * @return NULL if not a lan channel session, 
 *         assigned socket address information otherwhise
 */
struct sockaddr_in* pp_bmc_lanserv_get_sockaddr(imsg_session_t* session);

#endif

