/**
 * lan_ipmi15.h
 *
 * (c) 2005 Peppercon AG, Georg Hoesch <geo@peppercon.de>
 *
 * Handles the IPMIv15 messages for the ipmi class of RMCP
 */

#ifndef __LAN_IPMI15_H__
#define __LAN_IPMI15_H__

#include <pp/bmc/bmc_imsg.h>
#include <pp/bmc/lan_serv.h>

/**
 * Handle IPMIv15 rmcp message data. Removes the header and authenticates the session.
 */
int pp_ipmi15_receive(unsigned char* data, int len, lan_addr_t* addr);

/**
 * Send IPMIv15 rmcp messages. Authenticates the data and adds the session header.
 */
int pp_ipmi15_send_msg(unsigned char* data, int datalen, imsg_session_t* session, lan_addr_t* addr);

#endif
