/**
 * lan_serv_intern.h
 *
 * (c) 2005 Peppercon AG, Georg Hoesch <geo@peppercon.de>
 *
 * A lan channel adapter for the pp_bmc_core. Internal
 * functions that are not exported by the shared lib.
 */

#ifndef __PP_LAN_SERV_INTERN_H__
#define __PP_LAN_SERV_INTERN_H__

#include <pp/bmc/lan_serv.h>
#include <pp/bmc/bmc_router.h>

/**
 * Get the current lan channel configuration. This struct
 * remains the same while the channel exists and must not
 * be changed.
 */
const
pp_bmc_router_chan_adapter_config_t* get_lan_channel_config(void);

/**
 * Receive a message from the rmcp/rmcp+ ipmi layers.
 * 
 * This function assumes that the message either belongs to a session
 * with the privilege level session->cur_priv_level and is authenticated
 * within the session context or that the message is sent outside a
 * session (session==NULL, IPMIv15 only) with an implied privilege
 * level of IPMI_PRIV_UNSPEC.
 * 
 * @param data is a pointer to the data block containing the ipmi message
 *             as specified in figure 13-4 (ipmi20spec)
 * @param session the session reference if this msg is sent within a sesssion
 * @param userlevel_only set to 1 if this message is an unauthenticated message
 *             within a session. The 'user' privilege level will be assigned to
 *             this message instead of the session privilege level.
 * @param addr The lan channel specific data that is needed to return the message
 */
int pp_bmc_lanserv_ipmi_handle_receive(unsigned char* data, int ipmi_msg_len,
                                       imsg_session_t* session, unsigned char userlevel_only,
                                       lan_addr_t *addr);

#endif
