/**
 * rmcp.h
 *
 * (c) 2005 Peppercon AG, Georg Hoesch <geo@peppercon.de>
 *
 * This file handles
 * <ul>
 * <li> the RMCP layer (Switch by class, send ACKs), 
 * <li> ASF class of RMCP (PINGPONG)
 * <li> IPMI class (decision whether to forward this msg to IPMIv15
 *      or IPMIv20, hardwired)
 * </ul>
 */

#ifndef __RMCP_H__
#define __RMCP_H__

#include <pp/bmc/bmc_imsg.h>
#include <pp/bmc/lan_serv.h>

/**
 * Handle data from the lan.
 * both *data and *addr are pointers to structures on the stack which
 * are not persistent and will stop existing after this function terminates.
 */
int pp_rmcp_handle_receive(unsigned char* data, int len, struct sockaddr* addr, socklen_t* addr_len);

/**
 * Send message to rmcp layer. The data will be wrapped with an rmcp frame with
 * the specified class and sent to the specified lan address.
 */
int pp_send_rmcp_msg(unsigned char* data, int len, lan_addr_t* addr, unsigned char msg_class);

#endif
