/**
 * adm1024.h
 *
 * Implements the ADM1024 Monitor / Fan controller chip
 * Includes the i2c chip object as well as the sensor object
 * 
 * (c) 2005 Peppercon AG, 2005/11/22, thomas@peppercon.de
 */

#ifndef __PP_SENSOR_ADM1024_H__
#define __PP_SENSOR_ADM1024_H__

#include <pp/bmc/topo_base_obj.h>

#define ADM1024_MODEL_STRING "adm1024"

/* ppdoc
 * name:   ADM1024 chip
 * tpname: ADM1024
 * desc:   The ADM1024 chip object. This object configures the ADM1024 and
 * desc:   is needed for all ADM1024 sensor.
 * desc:   See also: ADM1024Sens
 * arg 0:  [OBJ(I2C_COM_DEV)] comdev: i2c device to be used
 * arg 1:  [INT] i2caddr:             i2c slave address of this device
 * arg 2:  [OBJ(COND)] powercond:     power on condition (chip will be
 * arg 2:                             initialized if condition changes to on,
 * arg 2:                             sensors won't be read while cond is false)
 * arg 3:  [INT] fan1_cfg:            Fan 1 ticks per revolution (1, 2 or 4)
 * arg 4:  [INT] fan2_cfg:            Fan 2 ticks per revolution (1, 2 or 4)
 * return: [OBJ(I2C_CHIP)]
 */
pp_tp_obj_t* pp_sensor_adm1024_ctor(const char* id, vector_t* args);

/* ppdoc
 * name:   ADM1024 sensor
 * tpname: ADM1024Sens
 * desc:   The ADM1024 sensor object, can dissolve to different sensors
 * desc:   depending on the arguments. Needs the ADM1024 chip object, see ADM1024.
 * arg 0:  [OBJ(I2C_CHIP)] chip: i2c chip, must be an ADM1024
 * arg 1:  [INT] sensor_no:      sensor number within chip
 * arg 1:                        0: Tacho 1
 * arg 1:                        1: Tacho 2
 * arg 1:                        2: VCCP1
 * arg 1:                        3: VCCP2
 * arg 1:                        4: 2.5V
 * arg 1:                        5: 5V
 * arg 1:                        6: 12V
 * arg 1:                        7: Internal Temp
 * arg 1:                        8: External Temp 1
 * return: [OBJ(SENS_DEV)]
 */
pp_tp_obj_t* pp_sensor_adm1024_sens_ctor(const char* id, vector_t* args);


/* some register symbols, as per spec ADM1024.pf */
#define ADM1024_REG_VALUE_25V            0x20
#define ADM1024_REG_VALUE_VCCP1          0x21
#define ADM1024_REG_VALUE_5V             0x23
#define ADM1024_REG_VALUE_12V            0x24
#define ADM1024_REG_VALUE_VCCP2          0x25
#define ADM1024_REG_VALUE_EXT_TEMP1      0x26
#define ADM1024_REG_VALUE_INTERNAL_TEMP  0x27
#define ADM1024_REG_VALUE_FAN1_AIN1      0x28
#define ADM1024_REG_VALUE_FAN2_AIN2      0x29
#define ADM1024_REG_CONFIG_REG_1         0x40
#define ADM1024_REG_CONFIG_REG_2         0x4a
#define ADM1024_REG_FAN_DEVISOR          0X47

#endif /* __PP_SENSOR_ADM1024_H__ */
