/**
 * adm1026.h
 *
 * implements the ADM1026 Monitor / Fan controller chip
 * This file includes all related objects (chip, sensors, pwm, gpio)
 * 
 * (c) 2005 Peppercon AG, 2005/10/28, thomas@peppercon.de
 */

#ifndef __PP_SENSOR_ADM1026_H__
#define __PP_SENSOR_ADM1026_H__

#include <pp/bmc/topo_base_obj.h>

#define ADM1026_MODEL_STRING "adm1026"


pp_tp_obj_t* pp_sensor_adm1026_ctor(const char* id, vector_t* args);

/* ppdoc
 * name:   ADM1026 chip
 * tpname: ADM1026
 * desc:   The ADM1026 chip object. This object configures the ADM1026 and
 * desc:   is needed for all ADM1026 sensor.
 * desc:   See also: ADM1026Sens
 * arg 0:  [OBJ(I2C_COM_DEV)] comdev: i2c device to be used
 * arg 1:  [INT] i2caddr:             i2c slave address of this device
 * arg 2:  [OBJ(COND)] powercond:     power on condition (chip will be
 * arg 2:                             initialized if condition changes to on,
 * arg 2:                             sensors won't be read while cond is false)
 * arg 3:  [INT] fan1_cfg:            Fan 1 ticks per revolution (1, 2 or 4)
 * arg 4:  [INT] fan2_cfg:            Fan 2 ticks per revolution (1, 2 or 4)
 * arg 5:  [INT] fan3_cfg:            Fan 3 ticks per revolution (1, 2 or 4)
 * arg 6:  [INT] fan4_cfg:            Fan 4 ticks per revolution (1, 2 or 4)
 * arg 7:  [INT] fan5_cfg:            Fan 5 ticks per revolution (1, 2 or 4)
 * arg 8:  [INT] fan6_cfg:            Fan 6 ticks per revolution (1, 2 or 4)
 * arg 9:  [INT] fan7_cfg:            Fan 7 ticks per revolution (1, 2 or 4)
 * arg 10: [INT] fan8_cfg:            Fan 8 ticks per revolution (1, 2 or 4)
 * return: [OBJ(I2C_CHIP)]
 */

pp_tp_obj_t* pp_sensor_adm1026_sens_ctor(const char* id, vector_t* args);

/* ppdoc
 * name:   ADM1026 sensor
 * tpname: ADM1026Sens
 * desc:   The ADM1026 sensor object, can dissolve to different sensors
 * desc:   depending on the arguments. Needs the ADM1026 chip object, see ADM1026.
 * arg 0:  [OBJ(I2C_CHIP)] chip: i2c chip, must be an ADM1026
 * arg 1:  [INT] sensor_no:      sensor number within chip
 * arg 1:                        0: Tacho 1
 * arg 1:                        1: Tacho 2
 * arg 1:                        2: Tacho 3
 * arg 1:                        3: Tacho 4
 * arg 1:                        4: Tacho 5
 * arg 1:                        5: Tacho 6
 * arg 1:                        6: Tacho 7
 * arg 1:                        7: Tacho 8
 * arg 1:                        8: VCCP
 * arg 1:                        9: 2.5V
 * arg 1:                        10: 5V
 * arg 1:                        11: 12V
 * arg 1:                        12:  -12V
 * arg 1:                        13: Internal Temp
 * arg 1:                        14: External Temp 1
 * arg 1:                        15: VBAT
 * arg 1:                        16: Remote Temp 1
 * arg 1:                        17: Remote Temp 2
 * arg 1:                        18: 3.3VSTBY
 * arg 1:                        19: 3.3VMAIN
 * return: [OBJ(SENS_DEV)]
 */


pp_tp_obj_t* pp_sensor_adm1026_pwm_ctor(const char* id, vector_t* args);
pp_tp_obj_t* pp_sensor_adm1026_gpio_ctor(const char* id, vector_t* args);


/* some register symbols, as per spec ADM1026.pf */
#define ADM1026_REG_CONFIG_REG_1 0x00 
#define ADM1026_REG_CONFIG_REG_2 0x01
#define ADM1026_REG_FAN03_DEVISOR 0x02
#define ADM1026_REG_FAN47_DEVISOR 0x03
#define ADM1026_FAN_DAC_CONTROL 0x04
#define ADM1026_PWM_CONTROL 0x05
#define ADM1026_EEPROM_FACTORY_REGISTER 0x06
#define ADM1026_GPIO_CONFIG_REGISTER 0x07
#define ADM1026_GPIO_CONFIG1 0x08
#define ADM1026_GPIO_CONFIG2 0x09
#define ADM1026_GPIO_CONFIG3 0x0A
#define ADM1026_GPIO_CONFIG4 0x0B
#define ADM1026_EEPROM_USER_REGISTER 0x0C
#define ADM1026_INTERNAL_HIGH_TEMP_LIMIT 0x0D 
#define ADM1026_TDM1_HIGH_TEMP_LIMIT 0x0E
#define ADM1026_TDM2_HIGH_TEMP_LIMIT 0x0F
#define ADM1026_INTERNAL_TEMP_VALUE 0x1F
#define ADM1026_REMOTE_1_TEMP_VALUE 0x28
#define ADM1026_REMOTE_2_TEMP_VALUE 0x29
#define ADM1026_REG_VALUE_FAN0 0x38
#define ADM1026_REG_VALUE_FAN1 0x39
#define ADM1026_REG_VALUE_FAN2 0x3A
#define ADM1026_REG_VALUE_FAN3 0x3B
#define ADM1026_REG_VALUE_FAN4 0x3C
#define ADM1026_REG_VALUE_FAN5 0x3D
#define ADM1026_REG_VALUE_FAN6 0x3E
#define ADM1026_REG_VALUE_FAN7 0x3F
#define ADM1026_REG_VALUE_VBAT 0x26
#define ADM1026_REG_VALUE_3STBY 0x2A
#define ADM1026_REG_VALUE_3MAIN 0x2B
#define ADM1026_REG_VALUE_5V 0x2C
#define ADM1026_REG_VALUE_VCCP 0x2D
#define ADM1026_REG_VALUE_12V 0x2E
#define ADM1026_REG_VALUE_N12V 0x2F
#define ADM1026_REG_VALUE_AIN0 0x30
#define ADM1026_REG_VALUE_AIN1 0x31
#define ADM1026_REG_VALUE_AIN2 0x32
#define ADM1026_REG_VALUE_AIN3 0x33
#define ADM1026_REG_VALUE_AIN4 0x34
#define ADM1026_REG_VALUE_AIN5 0x35
#define ADM1026_REG_VALUE_AIN6 0x36
#define ADM1026_REG_VALUE_AIN7 0x37
#define ADM1026_REG_VALUE_AIN8 0x27

/*
#define ADM1026_10 Int Temp TMIN 28h (40oC)
#define ADM1026_11 TDM1 TMIN 40h (64oC)
#define ADM1026_12 TDM2 TMIN 40h (64oC)
#define ADM1026_13 EEPROM Register 3 00h
#define ADM1026_14 Test Register 1 00h
#define ADM1026_15 Test Register 2 00h
#define ADM1026_16 Manufacturer%/2big5-0s ID 41h
#define ADM1026_17 Revision 4xh
#define ADM1026_18 Mask Register 1 00h
#define ADM1026_19 Mask Register 2 00h
#define ADM1026_1A Mask Register 3 00h
#define ADM1026_1B Mask Register 4 00h
#define ADM1026_1C Mask Register 5 00h
#define ADM1026_1D Mask Register 6 00h
#define ADM1026_1E Int Temp Offset 00h
#define ADM1026_1F Int Temp Value 00h
#define ADM1026_20 Status Register 1 00h
#define ADM1026_21 Status Register 2 00h
#define ADM1026_22 Status Register 3 00h
#define ADM1026_23 Status Register 4 00h
#define ADM1026_24 Status Register 5 00h
#define ADM1026_25 Status Register 6 00h
#define ADM1026_26 VBAT Value 00h
#define ADM1026_27 AIN8 Value 00h
#define ADM1026_TDM1 Value 00h
*/
/* some default values (might be changeable, however we stay with the *
 * default for the time beeing                                        */



#endif /* __PP_SENSOR_ADM1026_H__ */
