/**
 * adm1031_sensor.h
 *
 * ADM1031 sensors
 * 
 * (c) 2005 Peppercon AG, rwa@peppecon.de
 */

#ifndef __ADM1031_SENSOR_H
#define __ADM1031_SENSOR_H

#include <pp/bmc/topo_base_obj.h>

/**
 * instances of ADM1031 sensors
 */

/* ppdoc
 * name:   ADM1031 sensor
 * tpname: ADM1031
 * desc:   ADM1031 sensor object. This object operates directly
 * desc:   on the i2c bus and does not need an i2c chip object.
 * arg 0:  [OBJ(I2C_COM_DEV)] i2cdev:  i2c device to be used
 * arg 1:  [INT] i2c_addr:             i2c slave address of this device
 * arg 2:  [INT] sensor_no:            sensor number within the chip
 * arg 3:  [OBJ(COND)] scan_cond:      (optional) power condition: sensor 
 * arg 3:                              won't be scanned if condition is false
 * return: [OBJ(I2C_COMDEV)]
 */
pp_tp_obj_t* pp_sensor_adm1031_ctor(const char* id, vector_t* args);


#endif /* __ADM1031_SENSOR_H */
