/**
 * ads7830_sensor.h
 *
 * ADS7830 ADC sensors
 * 
 * (c) 2005 Peppercon AG, rwa@peppecon.de
 */

#ifndef __ADS7830_SENSOR_H
#define __ADS7830_SENSOR_H

#include <pp/bmc/topo_base_obj.h>

/* ppdoc: 
 * name:   ADS7830 sensor
 * tpname: ADS7830
 * desc:   ADS7830 sensor chip. This sensor access the i2c bus directly
 * desc:   and does not need an i2c chip object.
 * arg 0:  [OBJ(I2C_COM_DEV)] i2cdev:  i2c device to be used
 * arg 1:  [INT] i2c_addr:             i2c slave address of this device
 * arg 2:  [INT] sensor_no:            sensor number
 * arg 2:                              0-7: voltage sensor (channel)
 * arg 3:  [INT] cfactor:              correction factor
 * arg 4:  [OBJ(COND)] scan_cond:      (optional) power condition. Sensor
 * arg 4:                              won't be scanned if condition is false
 * return: [OBJ(SENS_DEV)]
 */
pp_tp_obj_t* pp_sensor_ads7830_ctor(const char* id, vector_t* args);

#endif /* __ADS7830_SENSOR_H */
