/**
 * adt7463_pwm.h
 *
 * constructor for all ADT7463 pwm controllers
 * 
 * (c) 2005 Peppercon AG, 2005/05/24 thomas@peppercon.de
 */

#ifndef __PP_BMC_ADT7463_PWM_H__
#define __PP_BMC_ADT7463_PWM_H__

/* ppdoc
 * name:   ADT7463 pwm actor
 * tpname: ADT7463pwm
 * desc:   ADT7463 pwm controller, relies on ADT73 chip.
 * arg 0:  [OBJ(I2C_CHIP)] chip: i2c chip to be used, must be "adt7463"
 * arg 1:  [INT] pwm_ctrl:       pwm controller number within this device
 * arg 1:                        0: pwm1
 * arg 1:                        1: pwm2
 * arg 1:                        2: pwm3
 * return: [OBJ(PWM_CTRL)]
 */
pp_tp_obj_t* pp_adt7463_pwm_ctor(const char* id, vector_t* args);

#define PP_PWM_ADT7463_MAX_PWM_NUM 2

#endif /* __PP_BMC_ADT7463_PWM_H__ */
