/**
 * cheyenne_fan_ctrl.h
 *
 * An object controlling the fan speed on the AMD Cheyenne board.
 * 
 * (c) 2006 Peppercon AG, Mirko Klefker <mkl@peppercon.de>
 */

#ifndef _PP_BMC_TP_CHEYENNE_FAN_CTRL_H
#define _PP_BMC_TP_CHEYENNE_FAN_CTRL_H

#include <pp/bmc/tp_ctrl.h>
#include <pp/bmc/tp_gpio_multi_sens.h>

typedef struct {
    pp_tp_ctrl_t base;
    vector_t * pwm_actors;
    vector_t * temp_sensors;
    vector_t * fan_sensors;
    vector_t * mid_speed_sensors;
    pp_tp_gpio_multi_sens_t * fan_speed_multi_gpio;
    pp_tp_sensdev_subscriber_t temp_reading_subscriber;
    pp_tp_sensdev_subscriber_t gpio_subscriber;
    pp_tp_ipmi_sens_subscriber_t fan_event_subscriber;
    pp_tp_ipmi_sens_subscriber_t temp_event_subscriber;
    int crit_cnt, old_crit_cnt; /* must be signed! */
    int warn_cnt, old_warn_cnt; /* must be signed! */
    pp_tp_ipmi_sens_t * max_temp_sensor;
    u_char force_fan_speed;
} pp_cheyenne_fan_ctrl_t;

pp_tp_obj_t* pp_cheyenne_fan_ctrl_ctor(const char* id, vector_t* args);

/* ppdoc:
 * name:   Cheyenne Fan Controller
 * tpname: CheyenneFanCtrl
 * desc:   The fan controller for the AMD Cheyenne.
 * arg 0:  [OBJ(GPIO_MULTI_SENS)] multi_pgio: The multi-gpio sensor to read the override fan speed gpio signals.
					      It's a two bit value where 00 is 100% duty cycle, 01 is 70% and 10 os 40%.
					      If set to 11, default fan policy is used. 
 * arg 1:  [INT] pwm_count:   number of PWM actors
 * arg 2:  [INT] temp_count:  number of temperature sensors
 * arg 3:  [INT] fan_count:   number of fan sensors
 * arg 4:  [OBJ(PWM_ACT)] pwm1:   PWM actor
 * arg 5:  [...]                  (optional ?, repeated) overall pwm_count PWM actors must be specified
 * arg 6:  [OBJ(SENS_DEV)] temp1: Temperature sensor
 * arg 7:  [...]                  (optional ?, repeated) overall temp_count temperature sensors must be specified
 * arg 8:  [OBJ(SENS_DEV)] fan1:  (optional ?) Fan sensor
 * arg 9:  [...]                  (optional ?, repeated) overall fan_count fan sensors can be specified
 * return [OBJ(FAN_CTRL)]
 */
void pp_cheyenne_fan_ctrl_dtor(pp_tp_obj_t* this);

int pp_cheyenne_fan_ctrl_init(pp_cheyenne_fan_ctrl_t* this, pp_tp_obj_type_t type,
			      const char* id, pp_tp_obj_dtor_func_t dtor,
			      vector_t * pwm_actors, vector_t * temp_sensors,
			      vector_t * fan_sensors, vector_t * mid_speed_sensors,
			      pp_tp_gpio_multi_sens_t * fan_speed_multi_gpio);

void pp_cheyenne_fan_ctrl_cleanup(pp_cheyenne_fan_ctrl_t* this);

#endif /* _PP_BMC_TP_CHEYENNE_FAN_CTRL_H */
