/**
 * dummy_smx.c
 *
 * Dummy serial mux.
 * 
 * (c) 2006 Peppercon AG, geo@peppercon.de
 */

#include <pp/base.h>
#include <lara.h>
#include <pp/bmc/debug.h>
#include <pp/bmc/topo_factory.h>
#include <pp/bmc/tp_gpio_dev.h>
#include <pp/bmc/tp_smx_act.h>
#include "dummy_smx.h"

#define cname "[DummySmx]"

static int dummy_smx_switch_host_chassis(pp_tp_smx_act_t* o UNUSED) {
    pp_bmc_log_debug("%s ignored switch S-Mux to host-chassis", cname);
    return PP_SUC;
}

static int dummy_smx_switch_bmc_chassis(pp_tp_smx_act_t* o UNUSED) {
    pp_bmc_log_debug("%s ignored switch S-Mux to bmc-chassis", cname);
    return PP_SUC;
}

static int dummy_smx_switch_host_bmc(pp_tp_smx_act_t* o UNUSED) {
    pp_bmc_log_debug("%s ignored switch S-Mux to host-bmc", cname);
    return PP_SUC;
}

static void dummy_smx_dtor(pp_tp_obj_t* o) {
    if (o != NULL) {
	assert(PP_TP_OBJ_IS_TYPE(PP_TP_SMX_ACT, o));
	pp_tp_smx_act_t* this = (pp_tp_smx_act_t*)o;
	pp_tp_smx_act_cleanup(this);
	free(this);
    }
}

pp_tp_obj_t* pp_dummy_smx_ctor (const char* id, vector_t* args UNUSED) {
    pp_tp_smx_act_t* this = NULL;

    this = malloc(sizeof(pp_tp_smx_act_t));
    pp_tp_smx_act_init(this, PP_TP_SMX_ACT, id, dummy_smx_dtor,
			   dummy_smx_switch_host_chassis,
			   dummy_smx_switch_bmc_chassis,
			   dummy_smx_switch_host_bmc);

    return (pp_tp_obj_t*)this;
}
