/**
 * max7312_gpio_dev.h
 *
 * Device driver base class for the MAXIM MAX7312 I2C GPIO Extender
 * 
 * (c) 2006 Peppercon AG, Mirko Klefker <mkl@peppercon.de>
 */ 
#ifndef __PP_BMC_MAX7312_GPIO_DEVICE_H__
#define __PP_BMC_MAX7312_GPIO_DEVICE_H__

#include <pp/bmc/tp_i2c_comdev.h>
#include <pp/bmc/tp_gpio_dev.h>
#include <pp/bmc/tp_cond.h>

/**
 * conrete device for a MAX7312 extender
 */
typedef struct pp_max7312_gpio_dev_s {
    pp_tp_gpio_dev_t base;

    pp_tp_i2c_comdev_t *i2cdev;
    u_char i2caddr;
    
    pp_tp_cond_t* pres_cond;

    int value;
    
    int to_hndl;

    int (*get_val)(struct pp_max7312_gpio_dev_s *d);
    int (*set_reg)(struct pp_max7312_gpio_dev_s *d, u_char reg, u_long mask,
		   u_long val);
} pp_max7312_gpio_dev_t;

/* common register types for max7312 devices */
#define REG_INPUT	0
#define REG_OUTPUT	1
#define REG_POL_INV	2
#define REG_CONFIG	3

/**
 * device initializer
 * @returns PP_ERR if the initialization failed
 */
int pp_max7312_gpio_dev_init(pp_max7312_gpio_dev_t* d,
			     pp_tp_i2c_comdev_t* i2cdev,
			     u_char i2caddr, pp_tp_cond_t* pres_cond);

void pp_max7312_gpio_dev_cleanup(pp_tp_obj_t* d);

/* ppdoc:
 * name:   Philips MAX7312 i2c gpio expander
 * tpname: MAX9555Gpio
 * arg 0:  [OBJ(I2C_COM_DEV)] i2cdev: i2c device the extender is connected to
 * arg 1:  [INT] i2caddr:             i2c slave address of this extender
 * arg 2:  [OBJ(COND)] presence:      (optional) presence (power on) condition
 * return: [OBJ(GPIO_DEV)]
 */
pp_tp_obj_t* pp_max7312_gpio_dev_ctor(const char* id, vector_t* args);

#endif
