/**
 * msi_fan_ctrl.h
 *
 * Implements fan speed control for MSI servers.
 * 
 * (c) 2005 Peppercon AG, Georg Hoesch <geo@peppercon.de>
 */

#ifndef _PP_BMC_TP_MSI_FAN_CTRL_H
#define _PP_BMC_TP_MSI_FAN_CTRL_H

#include <pp/bmc/tp_ctrl.h>

typedef struct {
    pp_tp_ctrl_t base;
    
    pp_tp_sensdev_t* sys_temp_sensor;
    pp_tp_sensdev_t* cpu_temp_sensor;
    vector_t * pwm_actors;   // vector of tp_pwm_act_t* 
    
    pp_tp_sensdev_subscriber_t sys_temp_subscriber;
    pp_tp_sensdev_subscriber_t cpu_temp_subscriber;
    
    int cpu_pwm_fn;  // whether to pick fn0 or fn1
    int cpu_tmp;     // current cpu temperature
} pp_msi_fan_ctrl_t;

/* ppdoc
 * name:   MSI fan controller
 * tpname: MsiFanControl
 * desc:   Msi fan controller, very similar to Linear fan controller except that
 * desc:   the controller offers two functions that are selected by a second
 * desc:   temperature sensor. Function parameters are not configurable.
 * arg 0:  [OBJ(SENS_DEV)] systemp: system temperature sensor
 * arg 1:  [OBJ(SENS_DEV)] cputemp: cpu temperature sensor
 * arg 2:  [OBJ(PWM_ACT)] pwm_act1: pwm actor to control
 * arg 3:  [...]                    (optional, repeatable) arg 2 can be repeated
 * arg 3:                           to add additional pwm actors to the controller
 * return: [OBJ(PWM_CTRL)]
 */
pp_tp_obj_t* pp_msi_fan_ctrl_ctor(const char* id, vector_t* args);

void pp_msi_fan_ctrl_dtor(pp_tp_obj_t* this);

/**
 * initialize a msi fan control object. Sensors will be duplicated
 * internally. Control also takes ownership of pwm_actors vector but
 * duplicates the member objects itself.
 */
int pp_msi_fan_ctrl_init(pp_msi_fan_ctrl_t* this,
                        pp_tp_obj_type_t type, const char* id,
                        pp_tp_obj_dtor_func_t dtor,
                        pp_tp_sensdev_t* sys_temp_sens,
                        pp_tp_sensdev_t* cpu_temp_sens,
                        vector_t * pwm_actors);

void pp_msi_fan_ctrl_cleanup(pp_msi_fan_ctrl_t* this);

#endif
