/**
 * opma_smx.c
 * 
 * OPMA specific MUX switch
 * Copied from msi_smx.c bus uses different gpio lines. 
 * 
 * FIXME: currently this is just a skeleton that needs to be filled.
 * 
 * (c) 2005 Peppercon AG, geo@peppercon.de
 */

#include <pp/base.h>
#include <lara.h>
#include <pp/bmc/debug.h>
#include <pp/bmc/topo_factory.h>
#include <pp/bmc/tp_gpio_dev.h>
#include <pp/bmc/tp_smx_act.h>
#include "opma_smx.h"

typedef struct opma_smx_s {
    pp_tp_smx_act_t base;
    pp_tp_gpio_dev_t* gpio_dev;
} opma_smx_t;

static const char* cname = "[OPMAsmx]";

static int opma_smx_switch_host_chassis(pp_tp_smx_act_t* this) {

    opma_smx_t* t = (opma_smx_t*)this;

    pp_bmc_log_debug("%s switching S-Mux to host-chassis", cname);

    t->gpio_dev->set_val(t->gpio_dev, 0xF80, 0x800, 0); 
   
    return PP_SUC;
}

static int opma_smx_switch_bmc_chassis(pp_tp_smx_act_t* this) {

    opma_smx_t* t = (opma_smx_t*)this;

    pp_bmc_log_debug("%s switching S-Mux to bmc-chassis", cname);

    t->gpio_dev->set_val(t->gpio_dev, 0xF80, 0x200, 0); 

    return PP_SUC;
}

static int opma_smx_switch_host_bmc(pp_tp_smx_act_t* this) {

    opma_smx_t* t = (opma_smx_t*)this;

    pp_bmc_log_debug("%s switching S-Mux to host-bmc", cname);

    t->gpio_dev->set_val(t->gpio_dev, 0xF80, 0x580, 0); 

    return PP_SUC;
}

static void opma_smx_dtor(pp_tp_obj_t* o) {
    if (o != NULL) {
        assert(PP_TP_OBJ_IS_TYPE(PP_TP_SMX_ACT, o));
        opma_smx_t* this = (opma_smx_t*)o;
        pp_tp_gpio_dev_release(this->gpio_dev);
        pp_tp_smx_act_cleanup(&this->base);
        free(this);
    }
}

pp_tp_obj_t* pp_opma_smx_ctor (const char* id, vector_t* args) {
    pp_strstream_t err = PP_STRSTREAM_INITIALIZER;
    pp_tp_gpio_dev_t* gpio_dev;
    opma_smx_t* this = NULL;

    if (pp_tp_arg_scanf(args, 0, &err, "o<g>", &gpio_dev) != 1) {
        pp_bmc_log_error("%s (%s) failed: %s", cname, id,
                         pp_strstream_buf(&err));
    } else {
        this = malloc(sizeof(opma_smx_t));
        pp_tp_smx_act_init(&this->base, PP_TP_SMX_ACT, id, opma_smx_dtor,
                           opma_smx_switch_host_chassis,
                           opma_smx_switch_bmc_chassis,
                           opma_smx_switch_host_bmc);
        this->gpio_dev = pp_tp_gpio_dev_duplicate(gpio_dev);
	/* TODO(miba) init GPIO dev for used pins */
    }
    pp_strstream_free(&err);
    return (pp_tp_obj_t*)this;
}
