/**
 * pp_fpga_gpio_dev.h
 *
 * Device driver class for the ext_gpio in the KIMs FPGA
 * 
 * (c) 2005 Peppercon AG, Georg Hoesch <geo@peppercon.de>
 */

 
#ifndef __PP_BMC_FPGA_GPIO_DEVICE_H__
#define __PP_BMC_FPGA_GPIO_DEVICE_H__

#include <pp/bmc/tp_gpio_dev.h>
#include "sensor_scanner.h"

/**
 * concrete KIM FPGA ext_gpio device
 */
typedef struct pp_fpga_gpio_dev_s {
    pp_tp_gpio_dev_t base;

    unsigned long value;
    unsigned long mask;
    int valid;
    int fd_gpio;
    int cb_hndl;
    pp_sensor_startable_t startable;
} pp_fpga_gpio_dev_t;


/**
 * ext_gpio device initializer
 * @returns PP_ERR if the initialization failed
 */
int pp_fpga_gpio_dev_init(pp_fpga_gpio_dev_t* d, char* gpio_devname);

/* ppdoc
 * name:   Peppercon FPGA gpio device
 * tpname: FpgaGpio
 * desc:   Gpio device object for the GPIOs on the peppercon
 * desc:   management card (KIMxxx/KIRAxxx/etc).
 * arg 0:  [STRING] gpio_dev_name:  The gpio device name to use
 * arg 0:                           Valid names are "gpio-oc-0", "gpio-oc-1", "gpio-faraday"
 * return: [OBJ(GPIO_DEV)]
 */
pp_tp_obj_t* pp_fpga_gpio_dev_ctor(const char* id, vector_t* args);


#endif
