/**
 * pp_fpga_pwm_dev.h
 *
 * Device driver class for the PWMs in the KIM FPGA
 * 
 * (c) 2005 Peppercon AG, Ronald Wahl <rwa@peppercon.de>
 */
 
#ifndef _PP_BMC_FPGA_PWM_DEV_H
#define _PP_BMC_FPGA_PWM_DEV_H

#include <pp/bmc/tp_pwm_act.h>

typedef struct {
    pp_tp_pwm_act_t base;
    u_int pwm_num;
    int dev_fd;
    u_int frequency;
    pp_tp_pwm_mode_t mode;
    u_int invert;
} pp_fpga_pwm_dev_t;

/* ppdoc
 * name:   Peppercon FPGA PWM controller
 * tpname: FpgaPwm
 * desc:   Object for the PWM controllers on the peppercon management hardware
 * desc:   (KIRAxxx, KIMxxx, ...)
 * arg 0:  [INT] pwmno:     The number of the pwm controller (0-7)
 * arg 1:  [INT] frequency: The frequency for this pwm.
 * arg 2:  [BOOL] invert:   Whether to invert the output or not.
 * return: [OBJ(PWM_ACT)]
 */
pp_tp_obj_t* pp_fpga_pwm_dev_ctor(const char* id, vector_t* args);

void pp_fpga_pwm_dev_dtor(pp_tp_obj_t* d);

int pp_fpga_pwm_dev_init(pp_fpga_pwm_dev_t* this, pp_tp_obj_type_t type, const char* id,
			 pp_tp_obj_dtor_func_t dtor,
			 pp_tp_pwm_act_set_mode_func_t set_mode,
			 pp_tp_pwm_act_get_mode_func_t get_mode,
			 pp_tp_pwm_act_set_duty_cycle_func_t set_duty_cycle,
			 pp_tp_pwm_act_get_duty_cycle_func_t get_duty_cycle,
			 u_int pwm_num, u_int frequency, u_int invert);

void pp_fpga_pwm_dev_cleanup(pp_fpga_pwm_dev_t* this);

#endif /* _PP_BMC_FPGA_PWM_DEV_H */
