/**
 * tp_pp_i2c_dev.h
 *
 * A concrete i2c communication device that uses libpp_base
 * as device driver.
 * 
 * (c) 2005 Peppercon AG, 3/9/2005, tbr@peppecon.de
 */

#ifndef __TP_PP_I2C_DEV_H__
#define __TP_PP_I2C_DEV_H__

#include <pp/bmc/tp_i2c_comdev.h>
#include <pp/vector.h>

/**
 * The pp i2c device driver.
 * Includes a handle to a specific i2c device
 */
typedef struct {
    pp_tp_i2c_comdev_t base;

    u_char i2c_handle;
} pp_i2c_dev_t;


/**
 * PP i2c device initializer;
 */
int pp_i2c_dev_init(pp_i2c_dev_t* d, const char* id, char* i2c_devname);

/**
 * PP i2c device cleanup.
 */
void pp_i2c_dev_cleanup(pp_tp_obj_t* d);

/* ppdoc
 * name:   Peppercon i2c device
 * tpname: I2C
 * desc:   An i2c object for the i2c controllers on the peppercon management
 * desc:   hardware (KIMxxx, KIRAxxx, ...)
 * arg 0:  [STRING] i2c_dev_name:  The name of i2c bus to interface.
 * arg 0:                          Valid names are "ibm-0" and "asics-0" to "acics-4"
 * return: [OBJ(I2C_DEV)]
 */
pp_tp_obj_t* pp_i2c_dev_ctor (const char* id, vector_t* args);

/**
 * Destroy method
 */
void pp_i2c_dev_dtor (pp_tp_obj_t* d);


#endif
