/**
 * rc_cy8c26.h
 *
 * This implements a special rpc chip residing on RS485 bus
 * implemented by cypress relay controller. The object
 * will shadow registers of cypress, so that it will be possible
 * to execute bulk operations for polling all register values.
 *
 * (c) 2006 Peppercon AG, 2006/09/05 tbr@raritan.com
 */

#ifndef __PP_BMC_RC_CY8C26_H__
#define __PP_BMC_RC_CY8C26_H__

/*
 * relay controller registers
 */
#define RC_CY8C26_DEVICE_ID              0x00
#define RC_CY8C26_FW_VERSION_ID          0x01
#define RC_CY8C26_HW_CFG_VERSION         0x02

#define RC_CY8C26_RMS_VOLTAGE            0x03
#define RC_CY8C26_TEMPERATURE            0x04
#define RC_CY8C26_FREQUENCY              0x05

#define RC_CY8C26_CURRENT_0              0x06
#define RC_CY8C26_PHASE_SHIFT_0          0x07
#define RC_CY8C26_CURRENT_CB_THRESH_0    0x08
#define RC_CY8C26_RECEPTACLE_CTRL_0      0x09

#define RC_CY8C26_CURRENT_1              0x0a
#define RC_CY8C26_PHASE_SHIFT_1          0x0b
#define RC_CY8C26_CURRENT_CB_THRESH_1    0x0c
#define RC_CY8C26_RECEPTACLE_CTRL_1      0x0d

#define RC_CY8C26_CURRENT_2              0x0e
#define RC_CY8C26_PHASE_SHIFT_2          0x0f
#define RC_CY8C26_CURRENT_CB_THRESH_2    0x10
#define RC_CY8C26_RECEPTACLE_CTRL_2      0x11

#define RC_CY8C26_CURRENT_3              0x12
#define RC_CY8C26_PHASE_SHIFT_3          0x13
#define RC_CY8C26_CURRENT_CB_THRESH_3    0x14
#define RC_CY8C26_RECEPTACLE_CTRL_3      0x15

#define RC_CY8C26_CURRENT_4              0x16
#define RC_CY8C26_PHASE_SHIFT_4          0x17
#define RC_CY8C26_CURRENT_CB_THRESH_4    0x18
#define RC_CY8C26_RECEPTACLE_CTRL_4      0x19

#define RC_CY8C26_SWITCH_FW_UPLOAD       0x1a

/* ATTENTION: do not forget to adjust this, if changing above */
#define RC_CY8C26_REGISTER_MAX           0x1a
#define RC_CY8C26_REGISTER_CNT           (RC_CY8C26_REGISTER_MAX + 1)

/* some numbers to validate register addresses */
#define RC_CY8C26_COMMON_REG_MAX         0x05
#define RC_CY8C26_REGS_PER_OUTLET        4

/* offsets of regs in one outlet group */
#define RC_CY8C26_CURRENT_OFF            0
#define RC_CY8C26_PHASE_SHIFT_OFF        1
#define RC_CY8C26_CURRENT_CB_THRESH_OFF  2
#define RC_CY8C26_RECEPTACLE_CTRL_OFF    3
#define RC_CY8C26_REG_OFF(regname)       RC_CY8C26_##regname##_OFF

/* number highest valid register number depending on number of outlets */
#define RC_CY8C26_REG_MAX_PER_OUTLET(x)					\
    (RC_CY8C26_COMMON_REG_MAX + (RC_CY8C26_REGS_PER_OUTLET * (x)))
#define RC_CY8C26_REG_CNT_PER_OUTLET(x)		\
    (RC_CY8C26_REG_MAX_PER_OUTLET(x) + 1)

/* register per name and outlet number */
#define RC_CY8C26_REG(regn, ono)					\
    (RC_CY8C26_COMMON_REG_MAX + 1					\
     + (ono) * RC_CY8C26_REGS_PER_OUTLET				\
     + RC_CY8C26_REG_OFF(regn))

#define RC_CY8C29_MODEL_STRING "rccy8c29"

/*
 * ppdoc
 * name: CY8C26 RS485 chip
 * tpname: RCCY8C26
 * desc: cypress relay controller for PDU
 * arg 0: [OBJ(RS485_COM_DEV)] rs485dev: rs485 bus device to use
 * arg 1: [INT] rs485_addr:              slave address on RS485 bus
 * arg 2: [int] outlet_no:               number of outlets
 */
pp_tp_obj_t* pp_rc_cy8c26_chip_ctor(const char* id, vector_t* args);

/*
 * ppdoc
 * name: CY8C26 Gpio-dev
 * tpname: RCCY8C26Gpio
 * desc: GPIO dev for cypress relay controller chip 
 * arg 0: [OBJ(RS485_CHIP)] chip: the CY8C26 chip to use
 * arg 1: [INT] outlet:           the number of outlet in chip 0 - 4
 */
pp_tp_obj_t* pp_rc_cy8c26_gpio_ctor(const char* id, vector_t* args);

/*
 * ppdoc
 * name:   CY8C26 sensors-dev
 * tpname: CY8C26Sens
 * arg 0:  [OBJ(RS485_CHIP)] chip:rs485 chip, must be an PDU
 * arg 1:  [INT] sensor_no : sensor number within chip
 * alternative:
 * arg 1:  [INT] receptacle_sensor_no: sensor number for recaptcle in next arg
 * arg 2:  [INT] receptacle_no: receptacle for which sensor is selected
 * return: [OBJ(SENS_DEV)] 
 */
pp_tp_obj_t* pp_rc_cy8c26_sens_ctor(const char* id, vector_t* args);


#endif
