/**
 * rpc_disp_ctrl.h
 *
 * implements the PDU 7 Segment Display Controller
 * This file includes all related objects (sensors, gpio, actuator)
 * 
 * (c) 2006 Peppercon AG, 2006/4/26, george@raritan.com
 */
 
#include <pp/bmc/tp_gpio_multi_sens.h> 
#include <pp/bmc/tp_sensdev.h>
#include <pp/bmc/tp_gpio_dev.h>
#include <pp/bmc/tp_ctrl.h>
#include <pp/bmc/tp_actor.h>

/*
 * display actuator
 *******************/
#define RPC_DISP_MAX_NUMBER 2

typedef enum {
    PP_TP_DISP_CHAN = 0,
    PP_TP_DISP_VOLT = 1,
    PP_TP_DISP_CURR = 2,
    PP_TP_DISP_WAIT = 3,
    PP_TP_DISP_CBE  = 4,
    PP_TP_DISP_FLASH = 5,
} pp_tp_disp_mode_t;

typedef struct pp_tp_disp_act_s pp_tp_disp_act_t;

typedef int (*pp_tp_disp_act_set_mode_func_t)
    (pp_tp_disp_act_t*, pp_tp_disp_mode_t);
typedef int (*pp_tp_disp_act_set_value_func_t)
    (pp_tp_disp_act_t*, u_char);

struct pp_tp_disp_act_s {
    pp_tp_actor_t base;    
    pp_tp_disp_act_set_mode_func_t set_mode;
    pp_tp_disp_act_set_value_func_t set_value;
};

/*
 * init / cleanup
 */
static inline int
pp_tp_disp_act_init(pp_tp_disp_act_t* this, pp_tp_obj_type_t type,
		    const char* id, pp_tp_obj_dtor_func_t dtor,
		    pp_tp_disp_act_set_mode_func_t set_mode,
		    pp_tp_disp_act_set_value_func_t set_value) {
    if (PP_SUCCED(pp_tp_actor_init(&this->base, type, id, dtor))) {
	this->set_mode = set_mode;
	this->set_value = set_value;
	return PP_SUC;
    }
    return PP_ERR;
}

static inline void
pp_tp_disp_act_cleanup(pp_tp_disp_act_t* this) {
    pp_tp_actor_cleanup(&this->base);
}

/*
 * convinience functions
 */
static inline pp_tp_disp_act_t*
pp_tp_disp_act_duplicate(pp_tp_disp_act_t* this) {
    return (pp_tp_disp_act_t*)pp_tp_obj_duplicate((pp_tp_obj_t*)this);
}

pp_tp_obj_t* pp_rpc_disp_act_ctor(const char* id, vector_t* args) ;


/*
 * Display controller
 ***********************/
enum {
    DISP_SENSOR_BUT_UP,
    DISP_SENSOR_BUT_DOWN,
    DISP_SENSOR_VOLT,
    DISP_SENSOR_CURR00,    
    DISP_SENSOR_CURR01,
    DISP_SENSOR_CURR02,
    DISP_SENSOR_CURR03,
    DISP_SENSOR_CURR04,
    DISP_SENSOR_CURR05,
    DISP_SENSOR_CURR06,
    DISP_SENSOR_CURR07,
    DISP_SENSOR_CURR08,
    DISP_SENSOR_CURR09,
    DISP_SENSOR_CURR10,
    DISP_SENSOR_CURR11,
    DISP_SENSOR_CURR12,
    DISP_SENSOR_CURR13,
    DISP_SENSOR_CURR14,
    DISP_SENSOR_CURR15,
    DISP_SENSOR_CURR16,
    DISP_SENSOR_CURR17,
    DISP_SENSOR_CURR18,
    DISP_SENSOR_CURR19,
    DISP_SENSOR_CURR20,
    DISP_SENSOR_CBE,
    DISP_SENSOR_FLASH,
    DISP_SENSOR_NOFLASH,
    RPC_DISP_SENS_MAX
};

pp_tp_obj_t* pp_rpc_disp_ctrl_ctor(const char* id, vector_t* args);


