/**
 * rpc_pwr_sens.h
 *
 * implements the PDU Sensor / Receptacle controller chip
 * This file includes all related objects (chip, sensors, pwm, gpio)
 * 
 * (c) 2006 Peppercon AG, 2006/3/27, george@raritan.com
 */

#include <pp/bmc/tp_gpio_sens.h>

typedef struct pp_rpc_curr_sens_s{
    pp_tp_sensdev_t base;
    int curr[24];

    vector_t * sens;	
    vector_t * sens_subscribers;
    //pp_tp_sensdev_subscriber_t sens_subscr[RPC_DISP_SENS_MAX];
} pp_rpc_curr_sens_t;

pp_tp_obj_t* pp_rpc_curr_sens_ctor(const char* id, vector_t* args);

int pp_rpc_curr_sens_init(pp_rpc_curr_sens_t* this, pp_tp_obj_type_t type,
			  const char* id, pp_tp_obj_dtor_func_t dtor,
			  vector_t* sens);
void pp_rpc_curr_sens_dtor(pp_tp_obj_t* o);

typedef struct pp_rpc_max_curr_sens_s{
    pp_tp_sensdev_t base;
    pp_tp_sensdev_t* curr_sens;
    pp_tp_sensdev_subscriber_t sens_subscr;
} pp_rpc_max_curr_sens_t;
pp_tp_obj_t* pp_rpc_max_curr_sens_ctor(const char* id, vector_t* args);
int pp_rpc_max_curr_sens_init(pp_rpc_max_curr_sens_t* this,
			      pp_tp_obj_type_t type,
			      const char *id, pp_tp_obj_dtor_func_t dtor,
			      pp_tp_sensdev_t* curr_sens);

void rpc_max_curr_sens_dtor(pp_tp_obj_t* sens);

typedef struct pp_rpc_pwr_sens_s{
    pp_tp_sensdev_t base;
    int pwr[24];
    vector_t * sens;	
    vector_t * sens_subscribers;
} pp_rpc_pwr_sens_t;

pp_tp_obj_t* pp_rpc_pwr_sens_ctor(const char* id, vector_t* args);

int pp_rpc_pwr_sens_init(pp_rpc_pwr_sens_t* this, pp_tp_obj_type_t type,
			 const char* id, pp_tp_obj_dtor_func_t dtor,
			 vector_t* sens);
void pp_rpc_pwr_sens_dtor(pp_tp_obj_t* o);

typedef struct pp_rpc_apt_pwr_sens_s{
    pp_tp_sensdev_t base;
    //pp_tp_scan_sensdev_t base;	
    /* POWER sensors for caculate power */
    pp_tp_sensdev_t* volt_sens;
    pp_tp_sensdev_t* cur_sens;	
    pp_tp_sensdev_subscriber_t sens_subscr;
} pp_rpc_apt_pwr_sens_t;

pp_tp_obj_t* pp_rpc_apt_pwr_sens_ctor(const char* id, vector_t* args);
int pp_rpc_apt_pwr_sens_init(pp_rpc_apt_pwr_sens_t* this,
			     pp_tp_obj_type_t type,
			     const char *id, pp_tp_obj_dtor_func_t dtor,
			     pp_tp_sensdev_t* volt_sens,
			     pp_tp_sensdev_t* cur_sens);
void rpc_apt_pwr_sens_dtor(pp_tp_obj_t* sens);

typedef struct pp_rpc_rms_pwr_sens_s{
    pp_tp_sensdev_t base;
    pp_tp_sensdev_t* pwr_sens;
    pp_tp_sensdev_t* phase_sens;	
    int period;
    int avrgpwr[20];
    pp_tp_sensdev_subscriber_t sens_subscr;
} pp_rpc_rms_pwr_sens_t;
pp_tp_obj_t* pp_rpc_rms_pwr_sens_ctor(const char* id, vector_t* args);
int pp_rpc_rms_pwr_sens_init(pp_rpc_rms_pwr_sens_t* this,
			     pp_tp_obj_type_t type,
			     const char *id, pp_tp_obj_dtor_func_t dtor,
			     pp_tp_sensdev_t* pwr_sens,
			     pp_tp_sensdev_t* phase_sens, int period);

void rpc_rms_pwr_sens_dtor(pp_tp_obj_t* sens);

typedef struct pp_rpc_max_pwr_sens_s{
    pp_tp_sensdev_t base;
    pp_tp_sensdev_t* pwr_sens;
    pp_tp_sensdev_subscriber_t sens_subscr;
} pp_rpc_max_pwr_sens_t;
pp_tp_obj_t* pp_rpc_max_pwr_sens_ctor(const char* id, vector_t* args);
int pp_rpc_max_pwr_sens_init(pp_rpc_max_pwr_sens_t* this,
			     pp_tp_obj_type_t type,
			     const char *id, pp_tp_obj_dtor_func_t dtor,
			     pp_tp_sensdev_t* pwr_sens);

void rpc_max_pwr_sens_dtor(pp_tp_obj_t* sens);
