/**
 * w83791d_pwm.h
 *
 * implements W83791D pwm device
 * 
 * (c) 2005 Peppercon AG, 2005/11/08, thomas@peppercon.de
 */

#ifndef __W83791D_PWM_H__
#define __W83791D_PWM_H__

#include <pp/base.h>

/* ppdoc
 * name:   W83791d PWM actor
 * tpname: W83791DPwmAct
 * desc:   A PWM actor object for the w83791d PWMs.
 * arg 0:  [OBJ(I2C_CHIP)] chip: i2c chip, must be an W83791D
 * arg 1:  [INT] pwm_no:         pwm controller number
 * arg 1:                        0: PWM Drive 1
 * arg 1:                        1: PWM Drive 2
 * arg 1:                        2: PWM Drive 3
 * arg 1:                        3: PWM Drive 4
 * arg 1:                        4: PWM Drive 5
 * return: [OBJ(PWM_ACT)]
 */
pp_tp_obj_t* pp_sensor_w83791d_pwm_ctor(const char* id, vector_t* args);

#endif
