/**
 * w83791d_sensor.h
 *
 * "Super class" for all W83791D sensors
 * 
 * (c) 2005 Peppercon AG, 02/22/2005, thre@peppecon.de
 */

#ifndef __W83791D_SENSOR_H
#define __W83791D_SENSOR_H

#include <pp/bmc/topo_base_obj.h>

/* ppdoc
 * name:   W83791D sensor
 * tpname: W83791D
 * desc:   A sensor object for the w83791 chip. Dessolves to different sensors
 * desc:   depending on the arguments.
 * arg 0:  [OBJ(I2C_CHIP)] chip: i2c chip, must be an W83791d
 * arg 1:  [INT] sensor_no:      sensor number within the chip, whereas:
 * arg 1:                         0: Vcore
 * arg 1:                         1: VinR0
 * arg 1:                         2: 3.3V
 * arg 1:                         3: VinR1
 * arg 1:                         4: 12V
 * arg 1:                         5: -12V
 * arg 1:                         6: -5V
 * arg 1:                         7: 5VSB
 * arg 1:                         8: Vbat
 * arg 1:                         9: Tach1
 * arg 1:                        10: Tach2
 * arg 1:                        11: Tach3
 * arg 1:                        12: Tach4
 * arg 1:                        13: Tach5
 * arg 1:                        14: Temp1
 * arg 1:                        15: Temp2
 * arg 1:                        16: Temp3
 * arg 2: [OBJ(COND)] scan_cond: (optional) scan condition, sensors won't be
 * arg 2:                        read if condition is false
 * return: [OBJ(SENS_DEV)]
 */
pp_tp_obj_t* pp_sensor_w83791d_sens_ctor(const char* id, vector_t* args);

#define PP_SENSOR_W83791D_MAX_SENSOR_NUM 16

#endif /* __W83791D_SENSOR_H */
