/**
 * w83792d_sensor.h
 *
 * "Super class" for all Winbond W83792D sensors
 * 
 * (c) 2006 Peppercon AG, 03/24/2006, rgue@peppecon.de
 */

#ifndef __W83792D_SENSOR_H
#define __W83792D_SENSOR_H

#include <pp/bmc/topo_base_obj.h>

/* ppdoc
 * name:   W83792D sensor
 * tpname: W83792D
 * desc:   A sensor object for the w83792 chip. Dessolves to different sensors
 * desc:   depending on the arguments.
 * arg 0:  [OBJ(I2C_CHIP)] chip: i2c chip, must be an W83792d
 * arg 1:  [INT] sensor_no:      sensor number within the chip, whereas:
 * arg 1:                         0: VcoreA
 * arg 1:                         1: VcoreB
 * arg 1:                         2: Vin0
 * arg 1:                         3: Vin1
 * arg 1:                         4: Vin2
 * arg 1:                         5: Vin3
 * arg 1:                         6: 5VCC
 * arg 1:                         7: VSB
 * arg 1:                         8: VBAT
 * arg 1:                         9: FAN1
 * arg 1:                        10: FAN2
 * arg 1:                        11: FAN3
 * arg 1:                        12: FAN4
 * arg 1:                        13: FAN5
 * arg 1:                        14: FAN6
 * arg 1:                        15: FAN7
 * arg 1:                        16: Temp1
 * arg 1:                        17: Temp2
 * arg 1:                        18: Temp3
 * arg 1:                        19: Chassis
 * arg 2: [OBJ(COND)] scan_cond: (optional) scan condition, sensors won't be
 * arg 2:                        read if condition is false
 * return: [OBJ(SENS_DEV)]
 */
pp_tp_obj_t* pp_sensor_w83792d_sens_ctor(const char* id, vector_t* args);

#define PP_SENSOR_W83792D_MAX_SENSOR_NUM 19

#endif /* __W83792D_SENSOR_H */
