/**
 * w83793g.c
 *
 * implements the w83793g chip object
 * 
 * (c) 2006 Supermicro, 2006/04/04, Edward Pan<edwardp@supermicro.com>
 */

#include <malloc.h>
#include <pp/base.h>
#include <pp/bmc/debug.h>
#include <pp/bmc/ipmi_sdr.h>
#include <pp/bmc/topo_factory.h>
#include <pp/bmc/tp_i2c_chip.h>

#include "drivers/w83793g.h"

static void w83793g_dtor(pp_tp_obj_t* o);
static void w83793g_power_up(pp_tp_i2c_chip_t* this);

pp_tp_obj_t* pp_sensor_w83793g_ctor(const char* id, vector_t* args) {
    pp_strstream_t err = PP_STRSTREAM_INITIALIZER;
    pp_tp_w83793g_chip_t* o = NULL;
    pp_tp_i2c_comdev_t* i2cdev;
    int i2caddr;
    pp_tp_cond_t* init_cond;
    unsigned char pwm_pre_scale;

    if (pp_tp_arg_scanf(args, 0, &err, "o<i>do<sc>d<c>",
			&i2cdev, &i2caddr, &init_cond, &pwm_pre_scale) != 4) {
	pp_bmc_log_perror("%s(): '%s' failed: %s", ___F, id,
			  pp_strstream_buf(&err));
    } else {
	o = malloc(sizeof(pp_tp_w83793g_chip_t));
	pp_tp_i2c_chip_init(&o->base, PP_TP_I2C_CHIP, id, w83793g_dtor,
			    W83793G_MODEL_STRING, i2cdev, i2caddr, init_cond,
			    w83793g_power_up, NULL);
	o->pwm_pre_scale = pwm_pre_scale;
    }
    pp_strstream_free(&err);
    return (pp_tp_obj_t*)o;
}

static void w83793g_dtor(pp_tp_obj_t* o) {
    pp_tp_i2c_chip_t* this = (pp_tp_i2c_chip_t*)o;
    assert(this != NULL);
    pp_tp_i2c_chip_cleanup(this);
    free(this);
}

static void w83793g_power_up(pp_tp_i2c_chip_t* chip UNUSED) {

/* not needed yet, implement with PWM and GPIO functions

    pp_tp_w83793g_chip_t* this = (pp_tp_w83793g_chip_t*)chip;
    unsigned char r0, r1; unsigned int i;
    unsigned short gmask = this->gpio_mask & 0x0fff; // 12 gpios max
    unsigned short iomask = this->gpio_io_mask;
    unsigned char pwm_cfg_reg[5] = {
	W83793G_PWM_PRE_SCALE_REG_FAN_1,
	W83793G_PWM_PRE_SCALE_REG_FAN_2,
	W83793G_PWM_PRE_SCALE_REG_FAN_3,
	W83793G_PWM_PRE_SCALE_REG_FAN_4,
	W83793G_PWM_PRE_SCALE_REG_FAN_5,
	W83793G_PWM_PRE_SCALE_REG_FAN_6,
	W83793G_PWM_PRE_SCALE_REG_FAN_7,
	W83793G_PWM_PRE_SCALE_REG_FAN_8
    };
    
    if (PP_ERR == pp_tp_i2c_chip_pre_com(chip)) return;
    
    // setup gpios, gpio io mask, gpio mask
    // select io
    r0 = (gmask & 0xff) & (iomask & 0xff);
    r1 = ((gmask >> 8) & 0x0f) & ((iomask >> 8) & 0x0f);
       
    // check if none of gpio 6 - 9 are selected and disable as gpio
    // this will enable Fan4/5 and Pwm4/5 instead
    if ((gmask & 0x03c0) == 0) {
	r1 |= 0x10;
    }

    // write gpio config
    if (PP_ERR == pp_tp_i2c_chip_tx_byte_data(chip, W83793G_GPIO_CONTROL_REG_1,
					      r0) ||
	PP_ERR == pp_tp_i2c_chip_tx_byte_data(chip, W83793G_GPIO_CONTROL_REG_2,
					      r1)) {
	goto finally;
    }

    // write pwm prescaler config
    for (i = 0; i < sizeof(pwm_cfg_reg); ++i) {
	if (PP_ERR == pp_tp_i2c_chip_tx_byte_data(chip, pwm_cfg_reg[i],
						  this->pwm_pre_scale)) {
	    goto finally;
	}
    }
    
    // scanning should be enabled per default during power on
    
 finally:
    pp_tp_i2c_chip_post_com(chip);
*/
}

