/**
 * warthog_fan_ctrl.h
 *
 * An object controlling the fan speed on the AMD Warthog board.
 * 
 * (c) 2005 Peppercon AG, Ronald Wahl <rwa@peppercon.de>
 */

#ifndef _PP_BMC_TP_WARTHOG_FAN_CTRL_H
#define _PP_BMC_TP_WARTHOG_FAN_CTRL_H

#include <pp/bmc/tp_ctrl.h>

typedef struct {
    pp_tp_ctrl_t base;
    vector_t * pwm_actors;
    vector_t * temp_sensors;
    vector_t * fan_sensors;
    pp_tp_ipmi_sens_subscriber_t temp_subscriber;
    pp_tp_ipmi_sens_subscriber_t fan_subscriber;
    int warn_cnt, old_warn_cnt; /* must be signed! */
    int crit_cnt, old_crit_cnt; /* must be signed! */
} pp_warthog_fan_ctrl_t;

pp_tp_obj_t* pp_warthog_fan_ctrl_ctor(const char* id, vector_t* args);

/* ppdoc:
 * name:   Warthog Fan Controller
 * tpname: WarthogFanCtrl
 * desc:   The fan controller for the AMD Warthog. Not documented
 * arg 0:  [INT] pwm_count:   number of PWM actors
 * arg 1:  [INT] temp_count:  number of temperature sensors
 * arg 2:  [INT] fan_count:   number of fan sensors
 * arg 3:  [OBJ(PWM_ACT)] pwm1:   PWM actor
 * arg 4:  [...]                  (optional ?, repeated) overall pwm_count PWM actors must be specified
 * arg 5:  [OBJ(SENS_DEV)] temp1: Temperature sensor
 * arg 6:  [...]                  (optional ?, repeated) overall temp_count temperature sensors must be specified
 * arg 7:  [OBJ(SENS_DEV)] fan1:  (optional ?) Fan sensor
 * arg 8:  [...]                  (optional ?, repeated) overall fan_count fan sensors can be specified
 * return [OBJ(FAN_CTRL)]
 */
void pp_warthog_fan_ctrl_dtor(pp_tp_obj_t* this);

int pp_warthog_fan_ctrl_init(pp_warthog_fan_ctrl_t* this, pp_tp_obj_type_t type,
			     const char* id, pp_tp_obj_dtor_func_t dtor,
			     vector_t * pwm_actors, vector_t * temp_sensors,
			     vector_t * fan_sensors);

void pp_warthog_fan_ctrl_cleanup(pp_warthog_fan_ctrl_t* this);

#endif /* _PP_BMC_TP_WARTHOG_FAN_CTRL_H */
