/**
 * sensor.h
 *
 * Defines the IPMI interface as used by the BMC.
 * It is going to be used by the Sensor device of the BMC
 *
 * (c) 2004 Peppercon AG, 12/14/2004, tbr@peppecon.de
 * 
 * TODO: replace the pp_sensor_add_creation_callback with a variable
 *       argument list for pp_bmc_sensor_topology_parse()
 */

#ifndef __SENSOR_H__
#define __SENSOR_H__

#include <errno.h>
#include <pp/base.h>
#include <pp/bmc/topo_base_obj.h>


/**
 * New object push function. Defines the interface through which
 * newly created objects can be pushed to interested consumers.
 * @param obj the new object. If the consumer is interested in the
 *        object, he must duplicate it for himself.
 */
typedef void(*pp_bmc_object_creation_t)(pp_tp_obj_t* obj);

/*
 * The central sensor configuration function. Reads the sensor configuration
 * topology from a file, creates the object instances and pushes them to
 * interested consumers (bmc_dev_sensor, libpp_hardware, ...)
 * These customers must be given in the variable argument list which 
 * must be terminated by NULL
 * 
 * @return PP_OK or PP_ERR, errno will be set.
 */
int pp_bmc_sensor_topology_parse(const char* topofile, ...);

/**
 * initializes the sensor lib
 *
 * @return PP_SUC sensor lib successfully initialized
 *         PP_ERR initialization failed or already initialized
 */
int pp_bmc_sensor_topology_init(void);

/**
 * frees all resources in the sensor lib.
 * this is necessary as multiple sensor instances may share some
 * common data, for instance the vtable, if they belong to the same
 * type.
 * Shared data of sensors won't be deleted if a a conrete sensor instance
 * is going to be deleted
 */
void pp_bmc_sensor_topology_cleanup(void);

int pp_bmc_sensor_scanner_start(void);

int pp_bmc_sensor_scanner_stop(void);

#endif
