/**
 * topo_base_obj.h
 *
 * Defines the root topology object.
 *
 * (c) 2005 Peppercon AG, 3/9/2005, tbr@peppecon.de
 */

 
#ifndef _PP_BMC_TOPO_BASE_OBJ_H
#define _PP_BMC_TOPO_BASE_OBJ_H

#include <stdlib.h>
#include <pp/bmc/topo_classes.h>

typedef struct pp_tp_obj_s pp_tp_obj_t;

typedef void (*pp_tp_obj_dtor_func_t)(pp_tp_obj_t *);
typedef const char* (*pp_tp_obj_to_string_func_t)(pp_tp_obj_t *);

/*
 * topology object base type
 * 
 * inheritance is expressed by including the baseclass' structure
 * as the first element in the subclass' structure
 */
struct pp_tp_obj_s {
    pp_tp_obj_type_t type;
    char* id;
    int refcnt;
    
    /**
     * Cleanup the objects internal state. After calling
     * destroy(), object memory can be freed.
     */
    pp_tp_obj_dtor_func_t destroy;
    
    /**
     * Returns the objects id as human readable string.
     */
    pp_tp_obj_to_string_func_t to_string;
};

/**
 * generic object init
 */
int pp_tp_obj_init(pp_tp_obj_t* this, pp_tp_obj_type_t type, const char* id,
		   pp_tp_obj_dtor_func_t dtor);

/**
 * generic object cleanup. Childs can use this method to cleanup their superclass.
 */
static inline void
pp_tp_obj_cleanup(pp_tp_obj_t* this)
{
    free(this->id);
}

/*
 * some convience functions for calling the virtual object methods
 */
static inline const char*
pp_tp_obj_to_string(pp_tp_obj_t* this)
{
    return this->to_string(this);
}

/**
 * Object duplication / release
 */
static inline pp_tp_obj_t*
pp_tp_obj_duplicate(pp_tp_obj_t* this)
{
    this->refcnt++;
    return this;
}

static inline void
pp_tp_obj_release(pp_tp_obj_t* this)
{
    if (--this->refcnt == 0) this->destroy(this);
}

#endif /* _PP_BMC_TOPO_BASE_OBJ_H */
