/**
 * topo_classes.h
 *
 * Defines a data type to identify topology classes.
 * Also defines the common framework object classes.
 * The data type should be transparent at the moment
 * to allow the extension to more class subtypes if
 * necessary.
 * 
 * TODO: find a way to define external classes without
 * changing this file. (not possible with enum)
 * 
 * (c) 2005 Peppercon AG, 3/9/2005, tbr@peppecon.de
 */


/*
 * type codes for topo objects
 * we reserve one byte for each object level, i.e. MSB is for base
 * type,the following bytes for a subtype. This way we'll limit our
 * inheritence-depth, but 4 levels seem to be enough and we spare
 * a sophisticated type-code-magic
 * -----------------------------------------------------------------
 */
 
#ifndef __TOPO_CLASSES_H__
#define __TOPO_CLASSES_H__

/*
 * Classes
 * --------------
 */

typedef enum pp_tp_obj_type_e {
    PP_TP_I2C_COM_DEV			= 0x01000000,
      PP_I2C_DEV			= 0x01010000,
      PP_TP_I2C_MUX			= 0x01020000,

    PP_TP_I2C_CHIP                      = 0x05000000,
    
    PP_TP_GPIO_DEV			= 0x02000000,
      PP_FPGA_GPIO_DEV			= 0x02010000,
      PP_PCA955X_GPIO_DEV		= 0x02020000,
      PP_MAX7312_GPIO_DEV               = 0x02030000,
    
    PP_TP_SENS_DEV			= 0x03000000,
      PP_TP_GPIO_SENS			= 0x03010000,
      PP_TP_GPIO_MULTI_SENS		= 0x03020000,
      PP_TP_ACPI_POWER_STATE		= 0x03030000,
      PP_TP_COND			= 0x03040000,
	PP_TP_STATIC_COND		= 0x03040100,
	PP_TP_SENS_HAS_VALUE_COND	= 0x03040200,
      PP_TP_SCAN_SENS_DEV               = 0x03050000,
  
    PP_TP_IPMI_SENS			= 0x04000000,
      PP_TP_THRESH_IPMI_SENS		= 0x04010000,
      PP_TP_DISC_IPMI_SENS		= 0x04020000,
    
    PP_TP_SDR				= 0x06000000,
      PP_TP_CFG_SDR			= 0x06010000,
        PP_TP_THRESH_SDR		= 0x06010100,
        PP_TP_DISC_SDR			= 0x06010200,
    
    PP_TP_ACTOR				= 0x07000000,
      PP_TP_GPIO_ACT			= 0x07010000,
      PP_TP_GPIO_MULTI_ACT              = 0x07020000,
      PP_TP_PWM_ACT			= 0x07030000,
      PP_TP_SMX_ACT			= 0x07040000,  // seriell MUX actor

    PP_TP_CTRL				= 0x08000000,
      PP_TP_FAN_CTRL			= 0x08010000,
      PP_TP_GPIO_LOOP			= 0x08020000,
      PP_TP_DISP_CTRL                   = 0x08030000,
      PP_TP_LED_CTRL                    = 0x08040000,
      PP_TP_BEEP_CTRL                   = 0x08050000,
      PP_TP_OLLED_CTRL                  = 0x08060000,
    
    PP_TP_MUXED_SCANNER                 = 0x09000000,

    PP_TP_RS485_COM_DEV                 = 0x0a000000,
    
    PP_TP_RS485_CHIP                    = 0x0b000000,
    
} pp_tp_obj_type_t;

// masks used part of type code and masks out unused subclass levels
#define PP_TP_TYPE_MASK(t) (((t) & 0xffffff) ? ((t) & 0xffff) ? ((t) & 0xff) ? \
                            0xffffffff : 0xffffff00 : 0xffff0000 : 0xff000000)

// true if x is same or subclass of t
#define PP_TP_IS_TYPE(t, x) (((x) & PP_TP_TYPE_MASK(t)) == (t))

// true if type of o is same or subclass of t
#define PP_TP_OBJ_IS_TYPE(t, o) PP_TP_IS_TYPE(t, ((pp_tp_obj_t*)o)->type)

/*
 * Interfaces
 * -----------
 * 
 * Interfaces do not have type codes, they are a structure 
 * containing fkt pointers, that make up the interface.
 * If you want to use an interface of an object, you must know
 * that this interface is supported by that object and simply 
 * use its interface pointer.
 * When the interface is called back the caller must also supply the 
 * interface pointer as first parameter to the interface method (this).
 * In order to cast the interface pointer back to its actual object,
 * use the macro below. You do need to know the obj type where the
 * interface pointer was taken from. This is OK as the object itself is 
 * implementing the interface method and, of course, it knows its own type
 */

/**
 * cast inteface pointer back to obj pointer
 * @param intf_ptr       this ptr of interface
 * @param obj_type       type of object to cast to
 * @param obj_intf_elem  element in obj of type obj_type, implementing intf
 */
#define PP_TP_INTF_2_OBJ_CAST(intf_ptr, obj_type, obj_intf_elem) \
    ((obj_type *)                                                \
     ((char *)(intf_ptr)                                         \
      - (unsigned long)(&((obj_type*)0)->obj_intf_elem)))


#endif
