/**
 * pp_tp_acpi_power_state_opma.h
 *
 * A concrete implementation of the ACPI power state sensor for
 * OPMA compliant hardware.
 * 
 * (c) 2005 Peppercon AG, Ronald Wahl <rwa@peppercon.de>
 */

#ifndef _PP_BMC_ACPI_POWER_STATE_OPMA_H
#define _PP_BMC_ACPI_POWER_STATE_OPMA_H

#include <pp/vector.h>
#include <pp/bmc/tp_gpio_multi_sens.h>
#include <pp/bmc/tp_acpi_power_state.h>

typedef struct {
    pp_tp_acpi_power_state_t base;
    pp_tp_gpio_multi_sens_t * acpi_state_multi_gpio;
    pp_tp_sensdev_subscriber_t gpio_subscriber;
} pp_tp_acpi_power_state_opma_t;

/* ppdoc
 * name:   Acpi OPMA power state sensor
 * tpname: AcpiPowerStateOpma
 * desc:   IPMI ACPI PowerState OPMA sensor. This power state sensor
 * desc:   is based on a multi-gpio sensor that encodes multiple
 * desc:   powerstates as defined in the OPMA spec.
 * arg0:   [OBJ(GPIO_MULTI_SENS)] multi_pgio: The multi-gpio sensor to read the power state from.
 * return: [OBJ(ACPI_POWER_STATE)]
 */
pp_tp_obj_t* pp_tp_acpi_power_state_opma_ctor(const char* id, vector_t* args);

void pp_tp_acpi_power_state_opma_dtor(pp_tp_obj_t* this);

int pp_tp_acpi_power_state_opma_init(pp_tp_acpi_power_state_opma_t* this,
				  pp_tp_obj_type_t type, const char* id,
				  pp_tp_obj_dtor_func_t dtor,
			  pp_tp_gpio_multi_sens_t * acpi_state_multi_gpio);

void pp_tp_acpi_power_state_opma_cleanup(pp_tp_acpi_power_state_opma_t* this);

#endif /* _PP_BMC_ACPI_POWER_STATE_OPMA_H */
